#include <ipmitool/ipmi.h>
#include <ipmitool/ipmi_error.h>
#include <ipmitool/ipmi_strings.h>
#include <ipmitool/helper.h>

#if !defined(PP_FEAT_IPMI_SERVER) || defined (PP_FEAT_BMC_OEMCMDS_ONLY)
extern const struct valstr ipmi_rakp_return_codes[];
#endif

void ipmi_reset_error(int * error) {
	if (error) {
		*error = 0;
	}
}

void ipmi_set_error(int * error, int error_code) {
	if (error && (*error == 0)) {
		*error = error_code;
	}
}

const char * pp_ipmi_get_error_string(int error_code) {
	if (error_code > 0 && error_code <= 0xff) {
		return val2str((uint8_t)error_code, completion_code_vals);
	}
#if !defined(PP_FEAT_IPMI_SERVER) || defined(PP_FEAT_BMC_OEMCMDS_ONLY)
	if (error_code >= IPMI_ERROR_RMCP_PLUS_OFFSET && error_code < IPMI_ERROR_RMCP_PLUS_OFFSET + 100) {
		return val2str((uint8_t)(error_code - IPMI_ERROR_RMCP_PLUS_OFFSET), ipmi_rakp_return_codes);
	}
#endif
	switch (error_code) {
		case IPMI_ERROR_UNKNOWN_ERROR:
			return _("Unknown error occurred");
		case IPMI_ERROR_NO_RESPONSE:
			return _("No response from the device");
		case IPMI_ERROR_LOOKUP_FAILED:
			return _("Could not lookup host name. Did you type it correctly?");
		case IPMI_ERROR_NO_SUCH_DEVICE:
			return _("No such device");
		case IPMI_ERROR_AUTH_FAILED:
			return _("Device Authentication failed");
		case IPMI_ERROR_ESTABLISH_SESSION:
			return _("Could not establish IPMI session");
		case IPMI_ERROR_INVALID_PARAMETER:
			return _("Invalid parameter specified");
		case IPMI_ERROR_NOT_ENOUGH_MEMORY:
			return _("Not enough memory");
		case IPMI_ERROR_NETWORK:
			return _("A network error occurred");
		case IPMI_ERROR_NO_CONNECTION:
			return _("Could not connect to the device");
		case IPMI_ERROR_INTERNAL:
			return _("An internal error occurred");
		case IPMI_ERROR_NO_PRIVILEGE:
			return _("Your privilege level is insufficient");
		case IPMI_ERROR_CLOSE_SESSION:
			return _("Could not close IPMI session");
		case IPMI_ERROR_NO_HOSTNAME:
			return _("No device specified");
		case IPMI_ERROR_ENCRYPTION:
			return _("Encryption error");
		case IPMI_ERROR_SEND_FAILED:
			return _("Could not send IPMI message");
		case IPMI_ERROR_USERNAME_TOO_LONG:
			return _("Username too long");
		case IPMI_ERROR_NO_20_SUPPORT:
			return _("This BMC does not support IPMI v2 / RMCP+");
		case IPMI_ERROR_INTF_NOT_SUPPORTED:
			return _("The interface is not supported");
		case IPMI_ERROR_NO_PARAMETER:
			return _("No parameter specified for the command");
		case IPMI_ERROR_INVALID_COMMAND:
			return _("Invalid command");
		case IPMI_ERROR_NOT_CONNECTED:
			return _("Not connected");
		case IPMI_ERROR_COULD_NOT_USE_OPENIPMI:
			return _("Could not open OpenIPMI driver");
		case IPMI_ERROR_OPENIPMI_ERROR:
			return _("Error using OpenIPMI driver");
		case IPMI_ERROR_INCOMPLETE_UPLOAD:
			return _("Incomplete upload");
		case IPMI_ERROR_BAD_CRC:
			return _("Bad CRC");
		case IPMI_ERROR_INVALID_FIRMWARE:
			return _("Firmware invalid");
		case IPMI_ERROR_UPGRADE_FAILED:
			return _("Firmware upgrade failed");
		case IPMI_ERROR_NO_SERIAL_NUMBER_SET:
			return _("No serial number set");
		case IPMI_ERROR_SERIAL_ALREADY_SET:
			return _("Serial number already set");
		case IPMI_ERROR_NO_EMPTY_DEVICE:
			return _("No empty device");
		case IPMI_ERROR_INVALID_FILE_SIZE:
			return _("Invalid file size");
		case IPMI_ERROR_SMB_MOUNT_IN_PROGRESS:
			return _("SMB mount in progress");
		case IPMI_ERROR_IMAGE_ACCESS_FAILED:
			return _("Image access failed");
		case IPMI_ERROR_COULD_NOT_OPEN_FILE:
			return _("Could not open file");
		case IPMI_ERROR_FILE_ACCESS_ERROR:
			return _("File access error");
		case IPMI_ERROR_INVALID_CHANNEL:
			return _("Invalid Channel");
		case IPMI_ERROR_CHANNEL_NOT_LAN_CHANNEL:
			return _("Channel is not a LAN channel");
		case IPMI_ERROR_COULD_NOT_PARSE_IP_ADDR:
			return _("Could not parse IP address");
		case IPMI_ERROR_COULD_NOT_PARSE_MAC_ADDR:
			return _("Could not parse MAC address");
		case IPMI_ERROR_IMB_NOT_AVAILABLE:
			return _("IMB driver not available");
		case IPMI_ERROR_IMB_ERROR:
			return _("Error in IMB driver");
		case IPMI_ERROR_SELFTEST_NOT_SUPPORTED:
			return _("Self test not supported");
		case IPMI_ERROR_SELFTEST_FAILED:
			return _("Selftest failed");
		case IPMI_ERROR_SELFTEST_BUSY:
			return _("Another selftest is running");
		case IPMI_ERROR_SELFTEST_NO_RESULT:
			return _("No result on selftest");
		case IPMI_ERROR_SELFTEST_NO_MATCH:
			return _("Selftest result doesn't match requested test");
		default:
			return _("Unknown error");
	}
}

int pp_ipmi_is_auth_failed(int error_code) {
	return error_code == IPMI_ERROR_AUTH_FAILED;
}

int pp_ipmi_is_self_test_failed(int error_code) {
	return error_code == IPMI_ERROR_SELFTEST_FAILED;
}

int pp_ipmi_is_not_supported(int error_code) {
	return error_code == 0xc1;
}
