#ifdef WIN32
#include <pp/win32.h>
#endif
#include <stdio.h>
#include <ipmitool/ipmi_print.h>
#include <ipmitool.h>

#define LINE_BUFSIZE	4096

#ifdef WIN32
#define vsnprintf _vsnprintf
#define IPMI_UNUSED
#else
#define IPMI_UNUSED __attribute__ ((unused))
#endif

#define xNOLOG

#ifdef NOLOG

static void dummy_logfunc(const char *string IPMI_UNUSED) {
}

static void (*ipmi_logfunc)(const char*) = dummy_logfunc;

#else

static void console_logfunc(const char *string) {
	printf(string);
}

static void (*ipmi_logfunc)(const char*) = console_logfunc;

#endif


void pp_ipmi_set_logfunc(void (*logfunc)(const char*)) {
	ipmi_logfunc = logfunc;
}

int ipmi_printf(const char * format, ...) {
	char linebuf[LINE_BUFSIZE + 1];

	va_list ap;
	va_start(ap, format);

	if(ipmi_logfunc) {
		vsnprintf(linebuf, LINE_BUFSIZE, format, ap);
		linebuf[LINE_BUFSIZE] = '\0';

		ipmi_logfunc(linebuf);
	}

	va_end(ap);

	return 0;
}

