/*
 * Copyright (c) 2003 Sun Microsystems, Inc.  All Rights Reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * Redistribution of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * Redistribution in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any kind.
 * ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES,
 * INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED.
 * SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING
 * OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.  IN NO EVENT WILL
 * SUN OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA,
 * OR FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
 * PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
 * LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE,
 * EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 * You acknowledge that this software is not designed or intended for use
 * in the design, construction, operation or maintenance of any nuclear
 * facility.
 */

#include <stddef.h>
#include <pp/ipmi.h>
#include <ipmitool/ipmi.h>
#include <ipmitool/ipmi_strings.h>
#include <ipmitool/ipmi_constants.h>
#include <ipmitool/ipmi_print.h>


const struct valstr ipmi_channel_activity_type_vals[] = {
	{ 0, "IPMI Messaging session active" },
	{ 1, "Callback Messaging session active" },
	{ 2, "Dial-out Alert active" },
	{ 3, "TAP Page Active" },
	{ 0x00, NULL },
};


const struct valstr ipmi_privlvl_vals[] = {
	{ IPMI_SESSION_PRIV_CALLBACK,	"CALLBACK" },
	{ IPMI_SESSION_PRIV_USER,	"USER" },
	{ IPMI_SESSION_PRIV_OPERATOR,	"OPERATOR" },
	{ IPMI_SESSION_PRIV_ADMIN,	"ADMINISTRATOR" },
	{ IPMI_SESSION_PRIV_OEM,	"OEM" },
	{ 0xF,				"NO ACCESS" },
	{ 0xFF,				NULL },
};


const struct valstr ipmi_authtype_session_vals[] = {
	{ IPMI_SESSION_AUTHTYPE_NONE,     "NONE" },
	{ IPMI_SESSION_AUTHTYPE_MD2,      "MD2" },
	{ IPMI_SESSION_AUTHTYPE_MD5,      "MD5" },
	{ IPMI_SESSION_AUTHTYPE_PASSWORD, "PASSWORD" },
	{ IPMI_SESSION_AUTHTYPE_OEM,      "OEM" },
	{ 0xFF,                            NULL },
};


const struct valstr ipmi_authtype_vals[] = {
	{ IPMI_1_5_AUTH_TYPE_BIT_NONE,     "NONE" },
	{ IPMI_1_5_AUTH_TYPE_BIT_MD2,      "MD2" },
	{ IPMI_1_5_AUTH_TYPE_BIT_MD5,      "MD5" },
	{ IPMI_1_5_AUTH_TYPE_BIT_PASSWORD, "PASSWORD" },
	{ IPMI_1_5_AUTH_TYPE_BIT_OEM,      "OEM" },
	{ 0,                               NULL },
};



const struct valstr entity_id_vals[] = {
	{ 0x00, N_("Unspecified") },
	{ 0x01, N_("Other") },
	{ 0x02, N_("Unknown") },
	{ 0x03, N_("Processor") },
	{ 0x04, N_("Disk or Disk Bay") },
	{ 0x05, N_("Peripheral Bay") },
	{ 0x06, N_("System Management Module") },
	{ 0x07, N_("System Board") },
	{ 0x08, N_("Memory Module") },
	{ 0x09, N_("Processor Module") },
	{ 0x0a, N_("Power Supply") },
	{ 0x0b, N_("Add-in Card") },
	{ 0x0c, N_("Front Panel Board") },
	{ 0x0d, N_("Back Panel Board") },
	{ 0x0e, N_("Power System Board") },
	{ 0x0f, N_("Drive Backplane") },
	{ 0x10, N_("System Internal Expansion Board") },
	{ 0x11, N_("Other System Board") },
	{ 0x12, N_("Processor Board") },
	{ 0x13, N_("Power Unit") },
	{ 0x14, N_("Power Module") },
	{ 0x15, N_("Power Management") },
	{ 0x16, N_("Chassis Back Panel Board") },
	{ 0x17, N_("System Chassis") },
	{ 0x18, N_("Sub-Chassis") },
	{ 0x19, N_("Other Chassis Board") },
	{ 0x1a, N_("Disk Drive Bay") },
	{ 0x1b, N_("Peripheral Bay") },
	{ 0x1c, N_("Device Bay") },
	{ 0x1d, N_("Fan Device") },
	{ 0x1e, N_("Cooling Unit") },
	{ 0x1f, N_("Cable/Interconnect") },
	{ 0x20, N_("Memory Device") },
	{ 0x21, N_("System Management Software") },
	{ 0x22, N_("BIOS") },
	{ 0x23, N_("Operating System") },
	{ 0x24, N_("System Bus") },
	{ 0x25, N_("Group") },
	{ 0x26, N_("Remote Management Device") },
	{ 0x27, N_("External Environment") },
	{ 0x28, N_("Battery") },
	{ 0x00, NULL },
};

const struct valstr entity_device_type_vals[] = {
	{ 0x00, N_("Reserved") },
	{ 0x01, N_("Reserved") },
	{ 0x02, N_("DS1624 temperature sensor") },
	{ 0x03, N_("DS1621 temperature sensor") },
	{ 0x04, N_("LM75 Temperature Sensor") },
	{ 0x05, N_("Heceta ASIC") },
	{ 0x06, N_("Reserved") },
	{ 0x07, N_("Reserved") },
	{ 0x08, N_("EEPROM, 24C01") },
	{ 0x09, N_("EEPROM, 24C02") },
	{ 0x0a, N_("EEPROM, 24C04") },
	{ 0x0b, N_("EEPROM, 24C08") },
	{ 0x0c, N_("EEPROM, 24C16") },
	{ 0x0d, N_("EEPROM, 24C17") },
	{ 0x0e, N_("EEPROM, 24C32") },
	{ 0x0f, N_("EEPROM, 24C64") },
	{ 0x1000, N_("IPMI FRU Inventory") },
	{ 0x1001, N_("DIMM Memory ID") },
	{ 0x1002, N_("IPMI FRU Inventory") },
	{ 0x1003, N_("System Processor Cartridge FRU") },
	{ 0x11, N_("Reserved") },
	{ 0x12, N_("Reserved") },
	{ 0x13, N_("Reserved") },
	{ 0x14, N_("PCF 8570 256 byte RAM") },
	{ 0x15, N_("PCF 8573 clock/calendar") },
	{ 0x16, N_("PCF 8574A I/O Port") },
	{ 0x17, N_("PCF 8583 clock/calendar") },
	{ 0x18, N_("PCF 8593 clock/calendar") },
	{ 0x19, N_("Clock calendar") },
	{ 0x1a, N_("PCF 8591 A/D, D/A Converter") },
	{ 0x1b, N_("I/O Port") },
	{ 0x1c, N_("A/D Converter") },
	{ 0x1d, N_("D/A Converter") },
	{ 0x1e, N_("A/D, D/A Converter") },
	{ 0x1f, N_("LCD Controller/Driver") },
	{ 0x20, N_("Core Logic (Chip set) Device") },
	{ 0x21, N_("LMC6874 Intelligent Battery controller") },
	{ 0x22, N_("Intelligent Batter controller") },
	{ 0x23, N_("Combo Management ASIC") },
	{ 0x24, N_("Maxim 1617 Temperature Sensor") },
	{ 0xbf, N_("Other/Unspecified") },
	{ 0x00, NULL },
};

const struct valstr ipmi_channel_protocol_vals[] = {
	{ 0x00, "reserved" },
	{ 0x01, "IPMB-1.0" },
	{ 0x02, "ICMB-1.0" },
	{ 0x03, "reserved" },
	{ 0x04, "IPMI-SMBus" },
	{ 0x05, "KCS" },
	{ 0x06, "SMIC" },
	{ 0x07, "BT-10" },
	{ 0x08, "BT-15" },
	{ 0x09, "TMode" },
	{ 0x1c, "OEM 1" },
	{ 0x1d, "OEM 2" },
	{ 0x1e, "OEM 3" },
	{ 0x1f, "OEM 4" },
	{ 0x00, NULL },
};


const struct valstr ipmi_channel_medium_vals[] = {
	{ IPMI_CHANNEL_MEDIUM_RESERVED,	"reserved" },
	{ IPMI_CHANNEL_MEDIUM_IPMB_I2C,	"IPMB (I2C)" },
	{ IPMI_CHANNEL_MEDIUM_ICMB_1,	"ICMB v1.0" },
	{ IPMI_CHANNEL_MEDIUM_ICMB_09,	"ICMB v0.9" },
	{ IPMI_CHANNEL_MEDIUM_LAN,	"802.3 LAN" },
	{ IPMI_CHANNEL_MEDIUM_SERIAL,	"Serial/Modem" },
	{ IPMI_CHANNEL_MEDIUM_LAN_OTHER,"Other LAN" },
	{ IPMI_CHANNEL_MEDIUM_SMBUS_PCI,"PCI SMBus" },
	{ IPMI_CHANNEL_MEDIUM_SMBUS_1,	"SMBus v1.0/v1.1" },
	{ IPMI_CHANNEL_MEDIUM_SMBUS_2,	"SMBus v2.0" },
	{ IPMI_CHANNEL_MEDIUM_USB_1,	"USB 1.x" },
	{ IPMI_CHANNEL_MEDIUM_USB_2,	"USB 2.x" },
	{ IPMI_CHANNEL_MEDIUM_SYSTEM,	"System Interface" },
	{ 0x00, NULL },
};

const struct valstr completion_code_vals[] = {
	{ 0x00, N_("Command completed normally") },
	{ 0x81, N_("Invalid user name") },
	{ 0x82, N_("NULL user name not enabled") },
	{ 0xc0, N_("Node busy") },
	{ 0xc1, N_("Invalid command (not supported by the BMC)") },
	{ 0xc2, N_("Invalid command on LUN") },
	{ 0xc3, N_("Timeout") },
	{ 0xc4, N_("Out of space") },
	{ 0xc5, N_("Reservation cancelled or invalid") },
	{ 0xc6, N_("Request data truncated") },
	{ 0xc7, N_("Request data length invalid") },
	{ 0xc8, N_("Request data field length limit exceeded") },
	{ 0xc9, N_("Parameter out of range") },
	{ 0xca, N_("Cannot return number of requested data bytes") },
	{ 0xcb, N_("Requested sensor, data, or record not found") },
	{ 0xcc, N_("Invalid data field in request") },
	{ 0xcd, N_("Command illegal for specified sensor or record type") },
	{ 0xce, N_("Command response could not be provided") },
	{ 0xcf, N_("Cannot execute duplicated request") },
	{ 0xd0, N_("SDR Repository in update mode") },
	{ 0xd1, N_("Device firmeware in update mode") },
	{ 0xd2, N_("BMC initialization in progress") },
	{ 0xd3, N_("Destination unavailable") },
	{ 0xd4, N_("Insufficient privilege level") },
	{ 0xd5, N_("Command not supported in present state") },
	{ 0xff, N_("Unspecified error") },
	{ 0x00, NULL }
};

const struct valstr ipmi_chassis_power_control_vals[] = {
	{ IPMI_CHASSIS_CTL_POWER_DOWN,   "Down/Off" },
	{ IPMI_CHASSIS_CTL_POWER_UP,     "Up/On" },
	{ IPMI_CHASSIS_CTL_POWER_CYCLE,  "Cycle" },
	{ IPMI_CHASSIS_CTL_HARD_RESET,   "Reset" },
	{ IPMI_CHASSIS_CTL_PULSE_DIAG,   "Diag" },
	{ IPMI_CHASSIS_CTL_ACPI_SOFT,    "Soft" },
	{ 0x00, NULL },
};

const struct valstr ipmi_auth_algorithms[] = {
	{ IPMI_AUTH_RAKP_NONE,      "none"      },
	{ IPMI_AUTH_RAKP_HMAC_SHA1, "hmac_sha1" },
	{ IPMI_AUTH_RAKP_HMAC_MD5,  "hmac_md5"  },
	{ 0x00, NULL }
};

const struct valstr ipmi_integrity_algorithms[] = {
	{ IPMI_INTEGRITY_NONE,         "none" },
	{ IPMI_INTEGRITY_HMAC_SHA1_96, "hmac_sha1_96" },
	{ IPMI_INTEGRITY_HMAC_MD5_128, "hmac_md5_128" },
	{ IPMI_INTEGRITY_MD5_128 ,     "md5_128"      },
	{ 0x00, NULL }
};

const struct valstr ipmi_encryption_algorithms[] = {
	{ IPMI_CRYPT_NONE,        "none"        },
	{ IPMI_CRYPT_AES_CBC_128, "aes_cbc_128" },
	{ IPMI_CRYPT_XRC4_128,    "xrc4_128"    },
	{ IPMI_CRYPT_XRC4_40,     "xrc4_40"     },
	{ 0x00, NULL }
};

const struct valstr ipmi_boot_devices[] = {
	{ PP_IPMI_CHASSIS_SET_BOOTFLAG_NO_CHANGE,	"none"		},
	{ PP_IPMI_CHASSIS_SET_BOOTFLAG_FORCE_PXE,	"pxe"		},
	{ PP_IPMI_CHASSIS_SET_BOOTFLAG_FORCE_DISK,	"disk"		},
	{ PP_IPMI_CHASSIS_SET_BOOTFLAG_FORCE_SAFE_DISK,	"safe"		},
	{ PP_IPMI_CHASSIS_SET_BOOTFLAG_FORCE_DIAG,	"diag"		},
	{ PP_IPMI_CHASSIS_SET_BOOTFLAG_FORCE_CDROM,	"cd-rom"	},
	{ PP_IPMI_CHASSIS_SET_BOOTFLAG_FORCE_BIOS,	"bios"		},
	{ PP_IPMI_CHASSIS_SET_BOOTFLAG_FORCE_FLOPPY,	"floppy"	},
	{ 0x00, NULL }
};
