#ifndef IPMI_PPSCSI_H
#define IPMI_PPSCSI_H

#include "scsi_api.h"

typedef struct {
    scsi_dev_t *scsi_dev;
    uint32_t session_secret;
} ppscsi_ctx_t;

#ifdef WIN32
#pragma pack(1)
#endif

struct ppscsi_imsg_s {
    uint32_t session_id;
    uint32_t session_secret;
    uint8_t rs_addr;
    uint8_t rs_lun;
    uint8_t rq_addr;
    uint8_t rq_lun;
    uint8_t netfn;
    uint8_t cmd;
    uint8_t data[0];
} PACKED_STRUCT;

#ifdef WIN32
#pragma pack()
#endif

typedef struct ppscsi_imsg_s ppscsi_imsg_t;

#define SCSI_OPCODE_VENDOR_IPMI	    0xc2

#define SCSI_IPMI_OPEN_SESSION	    0x00
#define SCSI_IPMI_CLOSE_SESSION	    0x01
#define SCSI_IPMI_SEND_REQUEST	    0x02
#define SCSI_IPMI_GET_RESPONSE	    0x03

#ifdef WIN32
#pragma pack(1)
#endif

struct ppscsi_scsi_cmd_s {
    uint8_t opcode;	    /* SCSI_OPCODE_VENDOR_IPMI */
    uint8_t command;	    /* one of SCSI_IPMI_* */
    uint32_t session_secret;
    uint16_t timeout;
} PACKED_STRUCT;

#ifdef WIN32
#pragma pack()
#endif

typedef struct ppscsi_scsi_cmd_s ppscsi_scsi_cmd_t;

#endif

