/*****************************************************************************
* iipptr_bitmap.c                                                            *
*                                                                            *
* Copyright 2002 Peppercon AG                                                *
* Author: Thomas Rendelmann                                                  *
*                                                                            *
* Part of liberic_km                                                         *
* mouse driver iipps2 for Intelligent Mouse cursor Tracking                  *
*                                                                            *
* Contains functions for importing and exporting Windows Bitmap files (.BMP) *
* this module is not very flexible but this is not necessary here            *
*                                                                            *
* this is only needed for testing purposes !!                                *
*****************************************************************************/


#ifndef __IIPPTR_BITMAP_H

#define __IIPPTR_BITMAP_H

#include "iipptr_help.h"

/* Bitmap file header */
typedef struct s_bitmap_file_header {
	unsigned short bf_type;
	unsigned int bf_size;
	unsigned short bf_reserved1;
	unsigned short bf_reserved2;
	unsigned int bf_off_bits;
} __attribute__((packed)) t_bitmap_file_header;

/* Bitmap info header */
typedef struct s_bitmap_info_header {
	unsigned int bi_size;
	unsigned int bi_width;
	unsigned int bi_height;
	unsigned short bi_planes;
	unsigned short bi_bitcount;
	unsigned int bi_compression;
	unsigned int bi_size_image;
	unsigned int bi_x_per_meter;
	unsigned int bi_y_per_meter;
	unsigned int bi_clr_used;
	unsigned int bi_clr_important;
} __attribute__((packed)) t_bitmap_info_header;

/* obj function reads a bitmap file into a t_bitmap structure */
int read_bitmap(t_bitmap* bitmap, const char* filename);

/* obj function writes a t_bitmap structure into a bitmap file */
int write_bitmap(t_bitmap* bitmap, const char *filename);

/* obj function prints info and RGB values of the bitmap
   on the console */
int show_bitmap(t_bitmap * bitmap);

#if defined(PP_FEAT_CAT) || defined(PP_FEAT_KITTY_CAT)
/* returns bitmap within given borders */
int crop_bitmap(t_bitmap *cropped, t_bitmap *bitmap,
                u_int16_t left, u_int16_t right, 
                u_int16_t top, u_int16_t bottom);

/* returns bitmap cropped by frame of given color,
   if not NULL, left, right, top and bottom are set to crop borders */
int crop_bitmap_by_color(t_bitmap *cropped,
                         u_int16_t *left, u_int16_t *right,
                         u_int16_t *top, u_int16_t *bottom,
                         t_bitmap *bitmap, t_rgb color);

/* returns 1bit threshold bitmap
   mode 0 is all channels larger threshold, mode 1 is any */
int threshold_bitmap_by_color(t_bitmap *new, t_bitmap *bitmap, 
                              t_rgb threshold, int mode);
#endif /* PP_FEAT_CAT || PP_FEAT_KITTY_CAT */

#endif /* __IIPPTR_BITMAP_H */
