/*****************************************************************************
* iipptr_internal.h                                                          *
*                                                                            *
* Implements internal functions to move the mouse with the help of	     *
* the LARA Mouse Universe[tm]						     *
*                                                                            *
*****************************************************************************/

#ifndef _IIP_INTERNAL_H_
#define _IIP_INTERNAL_H_

#include <pp/propchange.h>

#include "driver.h"
#include <pp/grab.h>
#include <liberic_misc.h>
#include <pp/kvm.h>
#include "iipptr_data.h"
#include "kmebase_int.h"

#if defined(PP_FEAT_CAT) || defined(PP_FEAT_KITTY_CAT)
#include "cat_internal.h"
#endif /* PP_FEAT_CAT || PP_FEAT_KITTY_CAT */

typedef struct {
    pp_propchange_listener_t propchange_listener;
    driver_t* obj;
} local_propchange_listener_t;

typedef struct {
    /* array of pointers, one for each kvm unit
     *     - a ptr is NULL if no mem is allocated
     *     - each ptr points to an array, indexed by kvm port, holding
     *       a km_kvm_entry_t for each port */
    km_kvm_entry_t *kvm_port_state_list_units[PP_KVM_MAX_UNIT_COUNT];
    km_kvm_entry_t* current_kvm_port;
    pthread_mutex_t kvm_port_mtx;
    unsigned char old_buttonmask;	// remember buttons pressed
    pp_grab_client_t *grab_client;
    t_bitmap current_cursor_shape;
    t_bitmap current_cursor_mask;
    t_bitmap current_cursor_bg_shape;
    local_propchange_listener_t propchange_listener;
    int move_mouse_corner_flag;
    pthread_mutex_t move_mouse_corner_flag_mtx;
#if defined(PP_FEAT_CAT) || defined(PP_FEAT_KITTY_CAT)
    /* queues */
    cat_queue_t*                diffmap_queue;
    cat_queue_t*                ptr_move_queue;

    /* tracking */
    void*                       tr_data;
    void                        (*tr_sample)(driver_t *obj);
    void                        (*tr_resample)(driver_t *obj);
    void                        (*tr_reset)(const driver_t *obj);
    int64_t                     (*get_pos_estim)(const driver_t *obj,
                                                 u_int16_t *x, u_int16_t *y);
    int                         (*set_pos_estim)(const driver_t *obj,
                                                 u_char reliable,
                                                 u_int16_t x, u_int16_t y,
                                                 u_int64_t timestamp);
    
    /* runtime info */
    pp_stopwatch_t              update_timer;
#endif /* PP_FEAT_CAT || PP_FEAT_KITTY_CAT */
} data_imouse_t;


#define MOUSE_RASTER		1000	/* virtual mouse raster */

/* this is used for universe_state  */
#define ERIC_MOUSE_NOT_VALID	0
#define ERIC_MOUSE_IS_VALID	1
#define ERIC_MOUSE_GETTING	2
#define ERIC_MOUSE_NOT_YET	4
#define ERIC_MOUSE_NOT_NEEDED	8
#define ERIC_MOUSE_VALID_UNSYNC	16

/* this is used for table_mode */
#define ERIC_MOUSE_OFF		16
#define ERIC_MOUSE_ON		32

/* this is used for cursor_state */
#define ERIC_MOUSE_CURSOR_NOT_VALID	0
#define ERIC_MOUSE_CURSOR_IS_VALID	1
#define ERIC_MOUSE_CURSOR_GETTING	2

/* error codes for mouse universe detection */
#define ERIC_MOUSE_UNIVERSE_OK		 0
#define ERIC_MOUSE_UNIVERSE_FAILED	-1
#define ERIC_MOUSE_UNIVERSE_WARN_GOOD	-2
#define ERIC_MOUSE_UNIVERSE_WARN_BAD	-3

extern pthread_mutex_t km_kvm_mtx;

extern t_mouse_func non_mouse_corr;

/* obj function saves mouse data to config fs */
int get_mouse_universe(driver_t* obj);

/* obj function moves the mouse using determined values
   (x,y are absolute) */
extern int move_mouse(driver_t* obj,
		      int x, int y, int z,
		      const unsigned char buttonmask);

/* obj function moves the mouse directly (dx,dy are relative)*/
extern int move_mouse_direct(driver_t* obj, const int dx, const int dy, const int dz, 
			     const unsigned char buttonmask, 
			     const unsigned char scale);

/* obj function moves the mouse into the top left corner*/
extern int move_mouse_corner(driver_t* obj, const unsigned char buttonmask);

/* save/load mouse data to/from config fs */
int save_mouse_universe(driver_t* obj);
int load_mouse_universe(driver_t* obj, km_kvm_entry_t* port);

#endif
