#ifndef _KBD_H
#define _KBD_H

#define KBD_LAYOUT_PC104 0
#define KBD_LAYOUT_PC109 1
#define KBD_LAYOUT_MAC   2
#define MAX_KBD_LAYOUTS  3

#define KM_KBD_PC109_STR    "pc109"
#define KM_KBD_PC104_STR    "pc104"
#define KM_KBD_MAC_STR	    "mac"


#define MAX_KEYDEFS		128
#define MAX_SCANCODES_NORMAL	2
#define MAX_SCANCODES_SPECIAL	6
#define MAX_SPECIAL_KEYREQS	3
#define MAX_KEYSPECIALS		7
#define MAX_LAYOUT_NAME_SIZE	10		

#define KEY_TYPE_NONE		0
#define KEY_TYPE_NORMAL		1
#define KEY_TYPE_PREFIX		2
#define KEY_TYPE_SPECIAL	4

#define KEY_MOD_NONE		0
#define KEY_MOD_MODI		1
#define KEY_MOD_PERM		2


/* ----------------- data types --------------------------- */

/* additional key data for special keys
   and pre/postfixed ones */

typedef struct keyspecial_s {
    u_char keys[MAX_SPECIAL_KEYREQS];  /* keys to be active/pressed
						 for a special or prefix */

    u_char mk[MAX_SCANCODES_SPECIAL];  /* prefix or special make   */
    u_char brk[MAX_SCANCODES_SPECIAL]; /* postfix or special break */
} keyspecial_t;


/* main key data */

typedef struct keydef_s {
    u_char nr;
    u_char type;
    u_char mod;
    u_char sc[MAX_SCANCODES_NORMAL];
    u_char sc3;

    keyspecial_t *special;
} keydef_t;

/* key layout, basically just a number
   of key definitions */

typedef struct keylayout_s {
    u_char id;
    u_char count;
    char name[MAX_LAYOUT_NAME_SIZE];
    keydef_t keys[MAX_KEYDEFS];
    void (*cleanup) (struct keylayout_s*);
} keylayout_t;

typedef struct keystate_s {
    u_char state;
} keystate_t;

/* state of whole keyboard (per KVM port) */

typedef struct keyboard_state_s {
    keylayout_t* layout;
    keystate_t keys[MAX_KEYDEFS];
} keyboard_state_t;


keylayout_t* keylayout_104pc_init(void);
void keylayout_104pc_cleanup(keylayout_t *layout);

keylayout_t* keylayout_mac_init(void);
void keylayout_mac_cleanup(keylayout_t *layout);

keylayout_t* keylayout_109pc_init(void);
void keylayout_109pc_cleanup(keylayout_t *layout);
#endif /* _KBD_H */
