#include <stdio.h>
#include <stdlib.h>

#include <pp/base.h>

#include "kbd_intern.h"
#include "kbd.h"
#include "driver.h"

#define KEYDEF_NR_104PC	3

static keydef_t keydef_defaults[KEYDEF_NR_104PC] = {
    { 105,  KEY_TYPE_NORMAL, KEY_MOD_MODI, { 0xE0, 0x5B }, 0x8B, NULL },	/* LWIN		*/
    { 106,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0xE0, 0x5D }, 0x8D, NULL },	/* MENU		*/
    { 107,  KEY_TYPE_NORMAL, KEY_MOD_MODI, { 0xE0, 0x5C }, 0x8C, NULL }		/* RWIN		*/
};

static keylayout_t* layout = NULL;
static int init_keydefs(void);

keylayout_t* keylayout_104pc_init()
{
    layout = keylayout_init();
    layout->cleanup = keylayout_104pc_cleanup;
    layout->id = KBD_LAYOUT_PC104;
    strcpy(layout->name, KM_KBD_PC104_STR);
    
    layout->cleanup = keylayout_104pc_cleanup;
    
    init_keydefs();

    KD("Initialized kbd layout %d : %s\n", layout->id, layout->name);
    return layout;
}

void keylayout_104pc_cleanup(keylayout_t *_layout)
{
    keylayout_cleanup(_layout);
}

static int init_keydefs(void)
{
    int i;

    for(i=0; i<KEYDEF_NR_104PC; i++) {
	memcpy(&layout->keys[keydef_defaults[i].nr], &keydef_defaults[i], sizeof(keydef_t));
    }
    layout->count = 108;

    return 0;
}
