#include <stdio.h>
#include <stdlib.h>

#include <pp/base.h>

#include "kbd.h"
#include "kbd_intern.h"
#include "driver.h"

#define KEYDEF_NR_109PC	11

static keyspecial_t ks_hangul[MAX_KEYSPECIALS] = {
    {{115, 255, 255}, {0xF2, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}}
};

static keyspecial_t ks_hanja[MAX_KEYSPECIALS] = {
    {{116, 255, 255}, {0xF1, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}},
    {{255, 255, 255}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}}
};

static keydef_t keydef_defaults[KEYDEF_NR_109PC] = {
    {  28,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x3A, 0x00 }, 0x14, NULL },	/* CAPS		*/
    { 105,  KEY_TYPE_NORMAL, KEY_MOD_MODI, { 0xE0, 0x5B }, 0x8B, NULL },	/* LWIN		*/
    { 106,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0xE0, 0x5D }, 0x8D, NULL },	/* MENU		*/
    { 107,  KEY_TYPE_NORMAL, KEY_MOD_MODI, { 0xE0, 0x5C }, 0x8C, NULL },	/* RWIN		*/
    { 108,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x7B }, 0x85, NULL },		/* left from space (muhenkan) */
    { 109,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x79 }, 0x86, NULL },		/* right from space (henkan) */
    { 110,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x70 }, 0x87, NULL },		/* right of henkan (hiragana, katakana, roman) */
    { 112,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x7d }, 0x5D, NULL },		/* Japanese Yen */
    { 114,  KEY_TYPE_NORMAL, KEY_MOD_NONE, { 0x73 }, 0x51, NULL },		/* Japanese '\' */
    { 115, KEY_TYPE_SPECIAL, KEY_MOD_NONE, { 0x00 }, 0x00, ks_hangul },		/* korean language switch (hangul) */
    { 116, KEY_TYPE_SPECIAL, KEY_MOD_NONE, { 0x00 }, 0x00, ks_hanja  }		/* korean key hanja */
};

static keylayout_t* layout = NULL;
static int init_keydefs(void);

keylayout_t* keylayout_109pc_init()
{
    layout = keylayout_init();
    layout->cleanup = keylayout_109pc_cleanup;
    layout->id = KBD_LAYOUT_PC109;
    strcpy(layout->name, KM_KBD_PC109_STR);
    layout->cleanup = keylayout_109pc_cleanup;
    
    init_keydefs();

    KD("Initialized kbd layout %d : %s\n", layout->id, layout->name);
    return layout;
}

void keylayout_109pc_cleanup(keylayout_t *_layout)
{
    keylayout_cleanup(_layout);
}

static int init_keydefs(void)
{
    int i;

    for(i=0; i<KEYDEF_NR_109PC; i++) {
	memcpy(&layout->keys[keydef_defaults[i].nr], &keydef_defaults[i], sizeof(keydef_t));
    }
    layout->count = 117;

    return 0;
}
