/* layer: dummy target helper 
used in kx2 - does nothing.
*/

/* system includes */
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

/* local includes */
#include "driver.h"

/* local object functions */
static int cleanup(driver_t* obj);
static int reconfigure(driver_t* obj);
static int get_open_fd(driver_t*);
static int close_fd (driver_t*);
static int use_file(driver_t* obj , const char* file );
static int is_equal(driver_t* obj, driver_t* d);

int init_target_helper_dummy(driver_t * obj, target_para_t * /* tpt */) {

    /* create the driver */
    obj->target_helper.id = __FUNCTION__;
    obj->target_helper.is_equal = is_equal;
    obj->target_helper.data = NULL;
    obj->target_helper.cleanup = cleanup;
    obj->target_helper.reconfigure = reconfigure;
    obj->target_helper.get_open_fd = get_open_fd;
    obj->target_helper.close_fd = close_fd;
    obj->target_helper.use_file = use_file;
 
    return 0;
}

static int cleanup(driver_t *  /* obj */) {

    return 0;
}

static int reconfigure(driver_t * /* obj */) {

    return 0;

}

static int is_equal(driver_t * obj, driver_t * d ) {

    if (!strcmp(obj->target_helper.id, d->target_helper.id)) {

        return 1;

    } else {

        return 0;

    }

}

static int use_file(driver_t * /* obj */, const char * /* file */) {
  
    return 0;
}

static int close_fd(driver_t * /* obj */ ) {
 
    return 0;
}

static int get_open_fd(driver_t * /* obj */) {

    return 0;
}



