/* layer: target_helper
*/

/* system includes */
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

/* firmware includes */
#include <pp/base.h>
#include <liberic_misc.h>

/* local includes */
#include "driver.h"


typedef struct {
    /* TODO hard coded stuff */
    int fd;
} target_helper_ericfd_t;

/* local object functions */
static int cleanup(driver_t* obj);
static int reconfigure(driver_t* obj);
static int get_open_fd(driver_t*);
static int close_fd (driver_t*);
static int use_file(driver_t* obj , const char* file );
static int is_equal(driver_t* obj, driver_t* d);

int init_target_helper_ericfd(driver_t* obj, target_para_t * /* tpt */) {
    /* create the driver */
    target_helper_ericfd_t *th = (target_helper_ericfd_t*) malloc(sizeof(target_helper_ericfd_t));
    th->fd = eric_fd;
    obj->target_helper.id = __FUNCTION__;
    obj->target_helper.is_equal = is_equal;
    obj->target_helper.data = th;
    obj->target_helper.cleanup = cleanup;
    obj->target_helper.reconfigure = reconfigure;
    obj->target_helper.get_open_fd = get_open_fd;
    obj->target_helper.close_fd = close_fd;
    obj->target_helper.use_file = use_file;
    
    return 0;
}

static int cleanup(driver_t* obj ) {
    free(obj->target_helper.data);
    /* no data, no cleanup */
    return 0;
}

static int is_equal(driver_t* obj, driver_t* d) {
    if (!strcmp(obj->target_helper.id, d->target_helper.id)) {
	return 1;
    } else {
	return 0;
    }
}


static int reconfigure(driver_t * /* obj */) {
    /* no state, not reconfigure */
    return 0;
}

static int get_open_fd(driver_t* obj) {
    target_helper_ericfd_t *th = (target_helper_ericfd_t*)obj->target_helper.data;
    
    return th->fd;
}

    
static int close_fd (driver_t * /* obj */) {
    /* no op - ericfd should not be closed here */
    return 0;
}

static int use_file(driver_t * /* obj */, const char* file) {
    if (file && strstr(file, "/dev/eric")) {
	return 1;
    } else {
	return 0;
    }
}
