/* layer: target_helper
*/

/* system includes */
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/i2c-slave.h>

/* firmware includes */
#include <pp/base.h>
#include <liberic_misc.h>

/* local includes */
#include "driver.h"
#include "comm_proto_pppp.h"

/* our i2c-kme device */
#define I2C_KME_DEVICE	"/dev/i2c-kme"

typedef struct {
    /* TODO hard coded stuff */
    int fd;
} target_helper_i2c_t;

/* local object functions */
static int cleanup(driver_t* obj);
static int reconfigure(driver_t* obj);
static int get_open_fd(driver_t*);
static int close_fd (driver_t*);
static int use_file(driver_t* obj , const char* file );
static int is_equal(driver_t* obj, driver_t* d);

int init_target_helper_i2c(driver_t* obj , target_para_t * /* tpt */ ) {
    target_helper_i2c_t *th = (target_helper_i2c_t*) malloc(sizeof(target_helper_i2c_t));
    th->fd = -1;

    obj->target_helper.id = __FUNCTION__;
    obj->target_helper.is_equal = is_equal;
    obj->target_helper.data = th;
    obj->target_helper.cleanup = cleanup;
    obj->target_helper.reconfigure = reconfigure;
    obj->target_helper.get_open_fd = get_open_fd;
    obj->target_helper.close_fd = close_fd;
    obj->target_helper.use_file = use_file;

    return 0;
}

static int cleanup(driver_t* obj ) {
    free(obj->target_helper.data);

    return 0;
}

static int reconfigure(driver_t * /* obj */) {
    /* no state, not reconfigure */
    return 0;
}

static int is_equal(driver_t* obj, driver_t* d) {
    if (!strcmp(obj->target_helper.id, d->target_helper.id)) {
	return 1;
    } else {
	return 0;
    }
}


static int get_open_fd(driver_t* obj ) {
    target_helper_i2c_t *th = (target_helper_i2c_t*)obj->target_helper.data;

    if (!(th->fd > 0)) {
	/* there is no open device, just create one */
	th->fd = open(I2C_KME_DEVICE, O_RDWR);
	if (th->fd < 0) {
	    th->fd = -1;
	    goto out;
	}
    	if (ioctl(th->fd, I2C_DEVICE_SET_TRANSMITTER_MODE, I2C_MODE_MASTER) < 0) {
    	    pp_log_err("IOCTL I2C_DEVICE_SET_TRANSMITTER_MODE failed");
	    close(th->fd);
	    th->fd = -1;
    	    goto out;
    	}
    	if (ioctl(th->fd, I2C_DEVICE_SET_RECEIVER_MODE, I2C_MODE_SLAVE) < 0) {
    	    pp_log_err("IOCTL I2C_DEVICE_SET_TRANSMITTER_MODE failed");
	    close(th->fd);
	    th->fd = -1;
    	    goto out;
    	}
    
    }
 out:
    return th->fd;
}

    
static int close_fd (driver_t* obj ) {
    target_helper_i2c_t *th = (target_helper_i2c_t*)obj->target_helper.data;
    if (th->fd > 0) {
	/* there is an open file descriptor, just close it */
	close(th->fd);
	/* TODO: some error stuff */
	th->fd = -1;
    }
    
    return 0;
}

static int use_file(driver_t * /* obj */, const char* file ) {
    if (file && strstr(file, I2C_KME_DEVICE)) {
	return 1;
    } else {
	return 0;
    }
}
    
