/*********************************************************************
 * libpp_kvm: debug.h
 *
 * This file contains defines for debugging
 *
 ********************************************************************/

#ifndef _DEBUG_H
#define _DEBUG_H

#include <stdio.h>

#define D_SILENT	0
#define D_ERROR		1
#define D_NOTICE	2
#define D_VERBOSE	3

#define DEBUGLEVEL D_VERBOSE

#if DEBUGLEVEL >= D_ERROR
#define DP_ERROR(fmt, args...) { printf("KVM error: " ); printf(fmt, ##args); }
#else
#define DP_ERROR(fmt, args...)
#endif

#if DEBUGLEVEL >= D_NOTICE
#define DP_NOTICE(fmt, args...) { printf("KVM notice: " ); printf(fmt, ##args); }
#else
#define DP_NOTICE(fmt, args...)
#endif

#if DEBUGLEVEL >= D_VERBOSE
#define DP_VERBOSE(fmt, args...) { printf("KVM verbose: " ); printf(fmt, ##args); }
#else
#define DP_VERBOSE(fmt, args...)
#endif

#endif /* _DEBUG_H */
