#include <fcntl.h>
#include <unistd.h>
#include <liberic_misc.h>
#include <pp/cfg.h>
#include <pp/hal_icpmmd.h>
#include <pp/km.h>
#include <pp/um.h>
#include <pp_gpio.h>

#include "icpmmd.h"
#include "debug.h"

/* Implementation of KvmKbdSwitch.  */

#define ICPMMD_FUNC_KVM_SWITCHING	0

#define ICPMMD_DEFAULT_SELECTED_NODE	0

using namespace pp;

/* virtual method assignments */
/* method implementations */
using namespace pp;

KvmIcpMmd::KvmIcpMmd()
{
    DP_VERBOSE("%s called\n", ___F);
}

KvmIcpMmd::~KvmIcpMmd()
{
    /* destroy superclass */
}

int
KvmIcpMmd::Switch ( LinkClient* client, u_char unit, u_short target_port,
				u_char* data_link, u_char* video_link)
{
    pthread_mutex_t *mtx = &this->super._switchPortMtx;

    u_char channel = client->GetVideoLinkNumber();

    DP_NOTICE("%s: switching to unit/port %hhu/%hu on channel %hhu\n", ___F, unit, target_port, channel);

    MUTEX_LOCK(mtx);

    pp_hal_icpmmd_switch_kvm(target_port);

    /* Note: switch gives no feedback (really?) -> manually notify of port change */
    PortChanged( channel, unit, target_port );

    MUTEX_UNLOCK(mtx);
    return PP_SUC;
}

u_short
KvmIcpMmd::GetUnitPortCount( u_char unit)
{
    return unit == 0 ? 12 : 0;
}
