#include "link_client.h"

#define TRUE 1
#define FALSE 0

using namespace pp;

LinkClient::LinkClient ()
{
    m_session_id = 0;
    m_session_type = PP_KVM_DUMMY;
    m_data_link_id = -1;
    m_video_link_id = -1;
    m_target_port = -1;         // m_target_port = -1 not connected to any target
}	

LinkClient::LinkClient (eric_session_int_id_t session_id,
	pp_kvm_session_type_t session_type,
	int target_unit, int target_port )
{
    m_session_id = session_id;
    m_session_type = session_type;
    m_data_link_id = -1;
    m_video_link_id = -1;
    m_target_unit = target_unit;
    m_target_port = target_port;
}

LinkClient::~LinkClient ()
{
    // clean up;	
}

pp_kvm_session_type_t LinkClient::GetSessionType()
{
    return m_session_type;
}

eric_session_int_id_t LinkClient::GetSessionID()
{
    return m_session_id;
}

int
LinkClient::hasActiveLinks()
{
    int status;
    
    status = (m_data_link_id >= 0 && m_video_link_id >= 0);

    return status;
}

void
LinkClient::SetTargetPort(int unit, int port)
{
    m_target_unit = unit;
    m_target_port = port;
}

int
LinkClient::GetTargetPort()
{
    return m_target_port;
}

int
LinkClient::GetTargetUnit()
{
    return m_target_unit;
}

int
LinkClient::IsRemoteClient()
{
    if (m_session_type == PP_KVM_REMOTE)
	return TRUE;
    else
	return FALSE;
}

void
LinkClient::SetDataLinkId (int data_link_id)
{

    m_data_link_id = data_link_id;
}

void
LinkClient::SetVideoLinkId (int video_link_id)
{
    m_video_link_id = video_link_id;
}

int
LinkClient::GetDataLinkId()
{
    return m_data_link_id;
}

int
LinkClient::GetVideoLinkId()
{
    return m_video_link_id;
}

