#ifndef _LINK_CLIENT_H
#define _LINK_CLIENT_H

#include <liberic_session.h>
#include <pp/kvmdefs.h>
#include <pp/kvm.h>

#ifdef __cplusplus
extern "C" {

#endif
namespace pp
{


class LinkClient
{
public:

    // Constructors 

    LinkClient();

    LinkClient (eric_session_int_id_t session_id, pp_kvm_session_type_t session_type, int target_unit, int target_port);

    // Destructor

    virtual ~LinkClient();

    pp_kvm_session_type_t GetSessionType();

    eric_session_int_id_t GetSessionID();

    int IsRemoteClient();

    int hasActiveLinks();

    void SetTargetPort(int unit, int port); 

    int GetTargetUnit();

    int GetTargetPort();

    int GetDataLinkId();

    int GetVideoLinkId();

    void SetDataLinkId (int data_link_id);

    void SetVideoLinkId (int video_link_id);

private:
    eric_session_int_id_t m_session_id;	    // for permissions

    pp_kvm_session_type_t  m_session_type;  // local (e.g. KX2) or remote

    int m_data_link_id;
    int m_video_link_id;
    int m_target_unit;
    int m_target_port;
};

} // namespace pp

#ifdef __cplusplus
}
#endif

#endif // _LINK_CLIENT_H
