#include <liberic_um.h>

/* local includes */
#include "xx01iptt.h"
#include "debug.h"

using namespace pp;


/* Implementation of KvmXx01iptt (xx01ip-like device produced by Tangtop). */

KvmXx01iptt::KvmXx01iptt()
{
    DP_VERBOSE("%s called\n", ___F);

    /* construct superclass */
}

KvmXx01iptt::~KvmXx01iptt()
{
    /* destroy non-inherited members */

    /* destroy superclass */
}

int
KvmXx01iptt::Switch ( LinkClient* client, u_char unit, int target_port,
				u_char* data_link, u_char* video_link)
{
    pthread_mutex_t *mtx = &this->super.super._switchPortMtx;
    int ret = -1;
    int err;
    char key_seq[KVM_MAX_KEY_SEQ_SIZE];

	u_char channel = client->GetVideoLinkNumber();

    if (unit != 0) {
	DP_ERROR("%s: cannot switch to unit %d, only unit 0 supported\n", ___F, unit);
	return -1;
    }

    DP_NOTICE("%s: switching to port %d\n", ___F, target_port);

    MUTEX_LOCK(mtx);

    /* generate symbolic keyseq */
    snprintf(key_seq, sizeof(key_seq), "SCROLL_LOCK-SCROLL_LOCK-%1d-%1d-%1d",
	    /* first unit -> 1 */
	    unit+1,
	    /* two digits, first port -> "01" */
	    (target_port+1) / 10, (target_port+1) % 10);

    /* send the keys out */
    err = SendKeySeq ( channel, key_seq);
    if (err) goto bail;

    /* switch gives no feedback -> manually notify of port change */
    PortChanged( channel, unit, target_port);

    ret = 0;
bail:
    MUTEX_UNLOCK(mtx);
    return ret;
}
