/*
 * stuff shared among different um_ldap implementation files
 */
#ifndef __ERIC_UM_LDAP_INTERN_H__
#define __ERIC_UM_LDAP_INTERN_H__

#include <ldap.h>
#include <pp/profile.h>

typedef struct pp_ldap_s {
    LDAP* ld;				/* LDAP connection context */
    char* ld_server;                    /* server name we are connected to */
    int   ld_is_bound;                  /* wheter bound or anonymous */
    LDAP* ld_user;                      /* LDAP connection for user auth */
    char* ld_user_server;               /* server name we are connected to */
    int   ld_user_is_bound;             /* wheter bound or anonymous */
    int use_minimal_ldap;		/* !=0 if we use LDAP for auth only */
    pp_profile_type_t type;             /* the profile type to be created */
    char* user;                         /* identifier in case of user profile */
} pp_ldap_t;

#define PP_LDAP_T_INITIALIZER \
            { NULL, NULL, 0, NULL, NULL, 0, 0, PP_PROFILE_NONE, NULL }
#define PP_LDAP_T_INITIALIZER_DEV \
            { NULL, NULL, 0, NULL, NULL, 0, 0, PP_PROFILE_LDAP_DEV, NULL }
#define PP_LDAP_T_INITIALIZER_USER \
            { NULL, NULL, 0, NULL, NULL, 0, 0, PP_PROFILE_LDAP_USER, NULL }

#endif
