#include <liberic_net.h>
#include <pp/km.h>
#include <pp_netevent_proto.h>

#include "netevent_intern.h"

static void
ne_conn_handler (pp_net_conn_data_t * conn)
{
    ne_propchange_listener_t *listener;
    int prop, unregister;
    ne_km_encoder_desc_t encoder;
    char srv_version[NETEVENT_VERSION_STRING_SIZE] = "";
    char clt_version[NETEVENT_VERSION_STRING_SIZE] = "";
    
    snprintf(clt_version, sizeof(clt_version), "%s", NETEVENT_VERSION_STRING);
    
    ne_propchange_init (&listener, conn->bio);
    ne_km_encoder_init(&encoder, listener);

    if (PP_FAILED(eric_net_read_exact (listener->bio, srv_version, sizeof (srv_version), 1)) ||
    	strncasecmp(srv_version, clt_version, NETEVENT_VERSION_STRING_SIZE - 1) != 0 ||
    	PP_FAILED(eric_net_write_exact (listener->bio, clt_version, sizeof (clt_version), 1))) {
    	goto bail;
    }
    
    while ((prop = ne_read_prop(listener, &unregister)) >= 0) {
	ne_propchange_register (listener, prop, unregister);
    }

bail:
    ne_km_encoder_cleanup(&encoder);
    ne_propchange_free (listener);
    eric_net_close(conn->bio, NOWAIT);
}

static u_short
get_ne_port (void)
{
    return 4321;
}

int
ne_net_init (void)
{
    return eric_net_register_proto (PP_NET_PROTOCOL_TYPE_NET_EVENT,
				    "netevent", 1, get_ne_port,
				    eric_net_init_bio_standard,
				    ne_conn_handler);
}

void
ne_net_cleanup (void)
{
    eric_net_unregister_proto(PP_NET_PROTOCOL_TYPE_NET_EVENT);
}

/******************************************************************************
* low level protocol functions                                                *
******************************************************************************/

void ne_write_event(ne_propchange_listener_t * listener, unsigned prop, unsigned prop_flags) {
    u_int16_t a1 = cpu_to_be16 (prop), a2 = cpu_to_be16 (prop_flags);
    
    eric_net_write (listener->bio, &a1, sizeof (a1), 1);
    eric_net_write (listener->bio, &a2, sizeof (a2), 1);
}

int ne_read_prop(ne_propchange_listener_t * listener, int *unregister) {
    u_int16_t _prop;
    if (PP_SUCCED(eric_net_read_exact (listener->bio, &_prop, sizeof (_prop), 1))) {
    	int prop = be16_to_cpu(_prop);
    	*unregister = (prop & NETEVENT_UNREGISTER_MASK) ? 1 : 0;
    	prop &= ~NETEVENT_UNREGISTER_MASK;
    	return prop;
    }
    return -1;
}

