#ifndef _NETEVENT_INTERN_H_
#define _NETEVENT_INTERN_H_

#include <openssl/bio.h>

#include <pp/propchange.h>
#include <pp/km.h>
#include <pp/hash.h>

#define NETEVENT_DEBUG

#ifdef NETEVENT_DEBUG
# define D(fmt, args...)	pp_log("netevent: " fmt, ##args)
#else
# define D(fmt, args...)
#endif

typedef struct ne_propchange_listener_s
{
    pp_propchange_listener_t listener;
    BIO *bio;
    /* local input events are not handled via the propchange mechanism */
    int want_keyboard;
    int want_mouse;
    pp_hash_i_t *events;
} ne_propchange_listener_t;

typedef struct ne_km_encoder_desc_s
{
    pp_km_encoder_desc_t desc;
    ne_propchange_listener_t *listener;
} ne_km_encoder_desc_t;

int ne_net_init (void);
void ne_net_cleanup (void);

void ne_propchange_init (ne_propchange_listener_t ** listener, BIO * bio);
void ne_propchange_free (ne_propchange_listener_t * listener);
void ne_propchange_register (ne_propchange_listener_t * listener, unsigned prop, int unregister);

void ne_km_encoder_init (ne_km_encoder_desc_t *encoder, ne_propchange_listener_t * listener);
void ne_km_encoder_cleanup (ne_km_encoder_desc_t *encoder);

void ne_write_event(ne_propchange_listener_t * listener, unsigned prop, unsigned prop_flags);
int ne_read_prop(ne_propchange_listener_t * listener, int *unregister);	/* blocking! */

#endif
