/**	
 *	@file	CPPUserObject.h
 *	@brief	PP Version of CUserObject
 *
 */

#ifndef _CPPUserObject_h_
#define _CPPUserObject_h_

#include <pp/syms.h>
#include <pp/OS_Port.h>
#include <pp/RDM_Definitions.h>
#include <pp/UserObject.h>

/*----------------------------------------
 *	Equates
 *--------------------------------------*/

/*----------------------------------------
 *	Data Types
 *--------------------------------------*/

/*----------------------------------------
 *	Function Prototypes
 *--------------------------------------*/

/*----------------------------------------
 *	Forward References
 *--------------------------------------*/

/*----------------------------------------
 *	CNetConn Class
 *--------------------------------------*/

class CPPUserObject : public CUserObject
{
    public:

        CPPUserObject(const char * pUser, const char * pUserID, const char * pGroup, const char *pGroupID) 
        { 
            strcpy (user, pUser);
            strcpy (userID, pUserID);
            strcpy (group, pGroup);
            strcpy (groupID, pGroupID);
        };

	virtual	DWORD GetUserObjectType() { return UO_TYPE_CC; };

        virtual BOOL IsAdministrator () { return TRUE; };

        virtual BOOL IsDiagnosticEnabled () { return FALSE; };

        virtual const char* GetUserName () { return user; };

        virtual const char* GetGroupName () { return group; };

        virtual const char* GetGroupID () { return groupID; };

	virtual DWORD GetPermission ( const char * NOTUSED(SecurityId), const char * NOTUSED(uniqueId) ) { return TR_PERM_READWRITE; };

	virtual DWORD GetNodePermission ( const char * NOTUSED(SecurityId) ) { return TR_PERM_READWRITE; };

	virtual DWORD GetAuthentication() { return TR_LOCAL_AUTHENTICATED; } ;

        virtual BOOL AllowConcurrentAccess () { return TRUE; };

        virtual BOOL IsInterfaceEnabled ( const char * NOTUSED(InterfaceName) ) { return TRUE; };

        virtual const char* GetDialbackNumber () { return ""; };

	virtual BOOL IsPasswordExpired () { return FALSE; };

        virtual BOOL operator=( const CUserObject * NOTUSED(pUserObject) ) { return FALSE; };

        virtual DWORD GetUserMenuAccessPermission () { return 0x0FFF; };

        virtual const char * GetUserID() { return userID; };
    private:

        char user[RDM_MAX_USER_NAME];
        char userID[RDM_MAX_USER_NAME];
        char group[RDM_MAX_GROUP_NAME];
        char groupID[RDM_MAX_GROUP_ID];
};




/**
 * DEP_UpdateSessionHistory, needed by RDM/CSC. This is functionally related to 
 * authenticate so I did put this here ...
 */
bool                                //returns true on success, false otherwise.  
DEP_UpdateSessionHistory (
                const char* pSessionID,
                const char* pLoginTime,
                const char* pLogoutTime,
                const char* pLastResourceUsed,
                const char* pUserID,
                const char* pUserName,
                const char* pGroupID);


#endif // #ifndef _CPPUserObject_h_


