#include <pp/base.h>

#include "hw_subencs.h"

/**
 * encoding description structure, to be included in hwenc.c
 * specifies control information for the VSC hardware encoder for each
 * encoding variant we offer to clients
 */
vsc_encoding_desc_t hwenc_subencs[] = {
    /* RFB_HW_SUBENC_LRLE_15BIT_DIRECT_LOSSY */  
    {
	algo:			VSC_ALGO_LRLE,
	lrle_r_margin_rb:	1,
	lrle_r_margin_g:	1,
	lrle_c_margin_rb:	1,
	lrle_c_margin_g:	1,
	lrle_g_margin:		4,
	lrle_runlimit:		31,
	lrle_linecopy:		1,
	lrle_grey_force:	0,
	lrle_grey_disable:	0,
	lrle_grey_green:	1,
	lrle_color:		LRLE_COLOR_15BIT_DIRECT,
	lrle_runlimit_reacc:	31,
	down_mode:		0,
    },
    /* RFB_HW_SUBENC_LRLE_15BIT_DIRECT_LOSSLESS */  
    {
	algo:			VSC_ALGO_LRLE,
	lrle_r_margin_rb:	0,
	lrle_r_margin_g:	0,
	lrle_c_margin_rb:	0,
	lrle_c_margin_g:	0,
	lrle_g_margin:		3,
	lrle_runlimit:		31,
	lrle_linecopy:		1,
	lrle_grey_force:	0,
	lrle_grey_disable:	0,
	lrle_grey_green:	0,
	lrle_color:		LRLE_COLOR_15BIT_DIRECT,
	lrle_runlimit_reacc:	31,
	down_mode:		0,
    },
    /* RFB_HW_SUBENC_LRLE_7BIT_DIRECT_LOSSY */
    {
	algo:			VSC_ALGO_LRLE,
	lrle_r_margin_rb:	1,
	lrle_r_margin_g:	1,
	lrle_c_margin_rb:	1,
	lrle_c_margin_g:	1,
	lrle_g_margin:		10,
	lrle_runlimit:		31,
	lrle_linecopy:		1,
	lrle_grey_force:	0,
	lrle_grey_disable:	0,
	lrle_grey_green:	0,
	lrle_color:		LRLE_COLOR_7BIT_DIRECT,
	lrle_runlimit_reacc:	31,
	down_mode:		0,
    },
    /* RFB_HW_SUBENC_LRLE_7BIT_DIRECT_LOSSLESS */
    {
	algo:			VSC_ALGO_LRLE,
	lrle_r_margin_rb:	0,
	lrle_r_margin_g:	0,
	lrle_c_margin_rb:	0,
	lrle_c_margin_g:	0,
	lrle_g_margin:		10,
	lrle_runlimit:		31,
	lrle_linecopy:		0,
	lrle_grey_force:	0,
	lrle_grey_disable:	0,
	lrle_grey_green:	0,
	lrle_color:		LRLE_COLOR_7BIT_DIRECT,
	lrle_runlimit_reacc:	31,
	down_mode:		0,
    },
    /* RFB_HW_SUBENC_LRLE_4BIT_PALETTE_LOSSY */
    {
	algo:			VSC_ALGO_LRLE,
	lrle_r_margin_rb:	1,
	lrle_r_margin_g:	1,
	lrle_c_margin_rb:	0,
	lrle_c_margin_g:	0,
	lrle_g_margin:		0,
	lrle_runlimit:		31,
	lrle_linecopy:		0,
	lrle_grey_force:	0,
	lrle_grey_disable:	1,
	lrle_grey_green:	0,
	lrle_color:		LRLE_COLOR_4BIT_PALETTE,
	lrle_runlimit_reacc:	13,
	down_mode:		0,
    },
    /* RFB_HW_SUBENC_LRLE_4BIT_PALETTE_LOSSLESS */
    {
	algo:			VSC_ALGO_LRLE,
	lrle_r_margin_rb:	0,
	lrle_r_margin_g:	0,
	lrle_c_margin_rb:	0,
	lrle_c_margin_g:	0,
	lrle_g_margin:		0,
	lrle_runlimit:		31,
	lrle_linecopy:		0,
	lrle_grey_force:	0,
	lrle_grey_disable:	1,
	lrle_grey_green:	0,
	lrle_color:		LRLE_COLOR_4BIT_PALETTE,
	lrle_runlimit_reacc:	13,
	down_mode:		0,
    },
    /* RFB_HW_SUBENC_LRLE_4BIT_GREY_LOSSY */
    {
	algo:			VSC_ALGO_LRLE,
	lrle_r_margin_rb:	1,
	lrle_r_margin_g:	1,
	lrle_c_margin_rb:	0,
	lrle_c_margin_g:	0,
	lrle_g_margin:		0,
	lrle_runlimit:		31,
	lrle_linecopy:		1,
	lrle_grey_force:	1,
	lrle_grey_disable:	0,
	lrle_grey_green:	0,
	lrle_color:		LRLE_COLOR_4BIT_GREY,
	lrle_runlimit_reacc:	13,
	down_mode:		0,
    },
    /* RFB_HW_SUBENC_LRLE_4BIT_GREY_LOSSLESS */
    {
	algo:			VSC_ALGO_LRLE,
	lrle_r_margin_rb:	0,
	lrle_r_margin_g:	0,
	lrle_c_margin_rb:	0,
	lrle_c_margin_g:	0,
	lrle_g_margin:		0,
	lrle_runlimit:		31,
	lrle_linecopy:		0,
	lrle_grey_force:	1,
	lrle_grey_disable:	0,
	lrle_grey_green:	0,
	lrle_color:		LRLE_COLOR_4BIT_GREY,
	lrle_runlimit_reacc:	13,
	down_mode:		0,
    },
    /* RFB_HW_SUBENC_LRLE_3BIT_GREY_LOSSY */
    {
	algo:			VSC_ALGO_LRLE,
	lrle_r_margin_rb:	1,
	lrle_r_margin_g:	1,
	lrle_c_margin_rb:	0,
	lrle_c_margin_g:	0,
	lrle_g_margin:		0,
	lrle_runlimit:		31,
	lrle_linecopy:		0,
	lrle_grey_force:	1,
	lrle_grey_disable:	0,
	lrle_grey_green:	0,
	lrle_color:		LRLE_COLOR_3BIT_GREY,
	lrle_runlimit_reacc:	27,
	down_mode:		0,
    },
    /* RFB_HW_SUBENC_LRLE_3BIT_GREY_LOSSLESS */
    {
	algo:			VSC_ALGO_LRLE,
	lrle_r_margin_rb:	0,
	lrle_r_margin_g:	0,
	lrle_c_margin_rb:	0,
	lrle_c_margin_g:	0,
	lrle_g_margin:		0,
	lrle_runlimit:		31,
	lrle_linecopy:		0,
	lrle_grey_force:	1,
	lrle_grey_disable:	0,
	lrle_grey_green:	0,
	lrle_color:		LRLE_COLOR_3BIT_GREY,
	lrle_runlimit_reacc:	27,
	down_mode:		0,
    },
    /* RFB_HW_SUBENC_LRLE_2BIT_GREY_LOSSY */
    {
	algo:			VSC_ALGO_LRLE,
	lrle_r_margin_rb:	1,
	lrle_r_margin_g:	1,
	lrle_c_margin_rb:	0,
	lrle_c_margin_g:	0,
	lrle_g_margin:		0,
	lrle_runlimit:		31,
	lrle_linecopy:		0,
	lrle_grey_force:	1,
	lrle_grey_disable:	0,
	lrle_grey_green:	0,
	lrle_color:		LRLE_COLOR_2BIT_GREY,
	lrle_runlimit_reacc:	7,
	down_mode:		0,
    },
    /* RFB_HW_SUBENC_LRLE_2BIT_GREY_LOSSLESS */
    {
	algo:			VSC_ALGO_LRLE,
	lrle_r_margin_rb:	0,
	lrle_r_margin_g:	0,
	lrle_c_margin_rb:	0,
	lrle_c_margin_g:	0,
	lrle_g_margin:		0,
	lrle_runlimit:		31,
	lrle_linecopy:		0,
	lrle_grey_force:	1,
	lrle_grey_disable:	0,
	lrle_grey_green:	0,
	lrle_color:		LRLE_COLOR_2BIT_GREY,
	lrle_runlimit_reacc:	7,
	down_mode:		0,
    },
    /* RFB_HW_SUBENC_LRLE_1BIT_GREY_LOSSY */
    {
	algo:			VSC_ALGO_LRLE,
	lrle_r_margin_rb:	1,
	lrle_r_margin_g:	1,
	lrle_c_margin_rb:	0,
	lrle_c_margin_g:	0,
	lrle_g_margin:		0,
	lrle_runlimit:		31,
	lrle_linecopy:		0,
	lrle_grey_force:	1,
	lrle_grey_disable:	0,
	lrle_grey_green:	0,
	lrle_color:		LRLE_COLOR_1BIT_GREY,
	lrle_runlimit_reacc:	15,
	down_mode:		0,
    },
    /* RFB_HW_SUBENC_LRLE_1BIT_GREY_LOSSLESS */
    {
	algo:			VSC_ALGO_LRLE,
	lrle_r_margin_rb:	0,
	lrle_r_margin_g:	0,
	lrle_c_margin_rb:	0,
	lrle_c_margin_g:	0,
	lrle_g_margin:		0,
	lrle_runlimit:		31,
	lrle_linecopy:		0,
	lrle_grey_force:	1,
	lrle_grey_disable:	0,
	lrle_grey_green:	0,
	lrle_color:		LRLE_COLOR_1BIT_GREY,
	lrle_runlimit_reacc:	15,
	down_mode:		0,
    },
};

const vsc_encoding_desc_t *
hwenc_get_subenc(u_int idx)
{
    if (idx >= hwenc_get_nr_subencs()) {
	pp_log_err("Subencoding %d out of range, returning default\n", idx);
	return &hwenc_subencs[0];
    }
    
    return &hwenc_subencs[idx];
}

size_t
hwenc_get_nr_subencs(void )
{
    return sizeof(hwenc_subencs) / sizeof(vsc_encoding_desc_t);
}
