#ifndef _PP_RFB_H
#define _PP_RFB_H

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/types.h>
#include <pp/grab.h>
#include <liberic_net.h>
#include <liberic_session.h>
#include <openssl/bio.h>
#include <lara.h>
#include <pp/vsc.h>

typedef struct _pp_rfb_session_data_t pp_rfb_session_data_t;

typedef enum {
    PP_RFB_NO_EXCLUSIVE_SESSION,
    PP_RFB_SESSION_NOT_EXCLUSIVE,
    PP_RFB_SESSION_IS_EXCLUSIVE
} pp_exclusive_info_t;

extern volatile int pp_rfb_disconnect_all;

int pp_rfb_init(void);
void pp_rfb_cleanup(void);
void pp_rfb_get_proto_version(unsigned int *major, unsigned int *minor);

typedef enum {
    PP_RFB_CLIENT_TYPE_TARGET,
    PP_RFB_CLIENT_TYPE_VIDEO_LINK,
    PP_RFB_CLIENT_TYPE_DATA_LINK,
    PP_RFB_CLIENT_TYPE_ALL /* in this case index is a don't care */
} client_index_type_t;
void pp_rfb_send_command(client_index_type_t type, u_short client_index, const char* command, const char* params);

void pp_rfb_handle_connection(pp_net_conn_data_t * conn_data);
int pp_rfb_is_active(unsigned char channel, eric_session_int_id_t id);
pp_exclusive_info_t pp_rfb_get_exclusive_session_info(eric_session_int_id_t id);
eric_session_int_id_t pp_rfb_get_excl_session(unsigned char channel);
void pp_rfb_do_disconnect(eric_session_int_id_t id);

unsigned int pp_rfb_get_connection_count(void);
unsigned int pp_rfb_get_non_forensics_connection_count(void);

#ifdef __cplusplus
}
#endif

#endif /* _PP_RFB_H */
