#include <stdlib.h>
#include <unistd.h>
#include <pp/base.h>
#include <pp/setup_proto.h>

int
main(int argc UNUSED, char ** argv)
{
    u_int8_t dev_id[6] = { 0xfe, 0x00, 0x00, 0x42, 0x03, 0x97 };
    pp_setup_req_t * req;
    pp_setup_rsp_t * rsp;

    if (pp_base_init(argv[0], LOG_NOT_SILENT) == -1) {
	pp_log("pp_base_init() failed.\n");
	exit(1);
    }

    if (pp_setup_proto_init() == -1) {
	pp_log("pp_setup_proto_init() failed.\n");
	exit(1);
    }

    if ((req = pp_setup_proto_req_create(NULL, 0, 0, 0)) == NULL) {
	pp_log("pp_setup_proto_req_create() failed.\n");
	exit(1);
    }

    pp_setup_proto_req_set_device_id(req, dev_id);

    pp_setup_proto_req_set_property(req, PP_SP_PROP_SUPER_USER_NAME, "super");
    pp_setup_proto_req_set_property(req, PP_SP_PROP_SUPER_USER_PASSWORD, "eric");
    pp_setup_proto_req_set_property(req, PP_SP_PROP_IP_AUTO_CONFIG_PROTO, "none");
    pp_setup_proto_req_set_property(req, PP_SP_PROP_IP_ADDRESS, "192.168.1.21");
    pp_setup_proto_req_set_property(req, PP_SP_PROP_NETMASK, "255.255.255.0");
    pp_setup_proto_req_set_property(req, PP_SP_PROP_GATEWAY, "192.168.1.1");

    pp_setup_proto_req_send(req);

    if ((rsp = pp_setup_proto_rsp_recv()) != NULL) {
	const char * serial;
	pp_log("received valid response (code: %d).\n",
	       pp_setup_proto_rsp_get_code(rsp));
	if ((serial = pp_setup_proto_rsp_get_property(rsp, "serial"))) {
	    pp_log("serial = %s\n", serial);
	}
    } else {
	pp_log("received invalid packet.\n");
    }

    return 0;
}
