#ifndef __USBD_H__
#define __USBD_H__

#ifdef __cplusplus
extern "C"
{
#endif

#include <pp/base.h>
#include <liberic_net.h>
/* kernel_usb requires pp/base.h included before */
#include <openssl/bio.h>
#include <kernel_usb.h>

/* public functions for usbd */

#define PP_USB_ERR_INTERNAL_ERROR	 (pp_usb_errno_base() + 0)
#define PP_USB_ERR_IMAGE_ACCESS_ERROR	 (pp_usb_errno_base() + 1)
#define PP_USB_ERR_IMAGE_IN_USE		 (pp_usb_errno_base() + 2)
#define PP_USB_ERR_NO_USB_CHIP           (pp_usb_errno_base() + 3)
#define PP_USB_ERR_SHARE_NOT_FOUND       (pp_usb_errno_base() + 4)
#define PP_USB_ERR_IMAGE_NOT_FOUND       (pp_usb_errno_base() + 5)

#ifdef PP_FEAT_MASS_STORAGE
typedef enum {
    PP_USB_MS_IMAGE_NONE,
    PP_USB_MS_IMAGE_SMB,
    PP_USB_MS_IMAGE_MEM,
    PP_USB_MS_IMAGE_MSP
} pp_usb_image_type_t;
#endif /* PP_FEAT_MASS_STORAGE */

/* functions return 0 on success */
int pp_usb_init(void);
void pp_usb_cleanup(void);

/* returns the errno base for this library */
int pp_usb_errno_base(void);

int pp_usb_is_possible(void);

#if defined(PP_FEAT_USB_FORCE_FS)
/* returns 1 if driver supports "force full speed" for keyb/mouse device */
int pp_usb_has_force_fs(void);
#endif

int pp_usb_send_data(u_int8_t channel, u_int8_t type, const void * data, size_t length);

int pp_usb_set_km(usb_device_kbd_type_t keyboard_type, usb_device_mouse_type_t mouse_type);
int pp_usb_reset_device(void);
/* get state of usb keyboard LEDs */
int pp_usb_get_led_state(void);

/* returns the device state as defined in kernel_usb.h */
usb_device_state_t pp_usb_get_device_state(void);

#ifdef PP_FEAT_MASS_STORAGE
int pp_usb_start_ms_bo_thread(void);
int pp_usb_enable_setup_proto(int enabled);

/* mass storage interface*/
unsigned int pp_usb_get_ms_count(void);

/* sets an image file, if setting was successful return 0 */
/* to remove an image: pp_usb_ms_set_image(NULL, dont_care); */
int pp_usb_ms_set_image(u_int ms_index, int fd, const char* path, size_t size, const char* name, int * error);
/* sets a smb image as mass storage, if setting was successful return 0 */
int pp_usb_ms_set_smb_image(u_int ms_index,
			    const char* const host, const char* share, const char* path,
			    const char* user, const char* pw, int * error);
/* remove/unset an image */
int pp_usb_ms_unset_image(u_int ms_index, int * error);
/* get the actual image type (smb, mem, none) */
pp_usb_image_type_t pp_usb_ms_get_image_type(u_int ms_index);
/* gets the actual image info, case (image_type)
   mem: type = "path"
   smb: type = "host"|"share"|"path"
*/
const char* pp_usb_ms_get_image_info(u_int ms_index, const char* type);
off_t pp_usb_ms_get_image_size(u_int ms_index);
int pp_usb_set_setup_rsp_packet(u_int ms_index, char* pdu, size_t len);

/******************************************************/
/*                                                    */
/*           Mass Storage functions declaration       */
/*                                    		      */
/******************************************************/

void pp_usb_msp_handle_connection(pp_net_conn_data_t * conn_data);
#endif /* PP_FEAT_MASS_STORAGE */

/* Virtual Media Management via IPMI */
typedef struct pp_usb_vfup_ctx_s pp_usb_vfup_ctx_t;

pp_usb_vfup_ctx_t *pp_usb_vfup_start(int device_id, int size, const char *name);
void pp_usb_vfup_delete(pp_usb_vfup_ctx_t *ctx);
int pp_usb_vfup_add_chunk(pp_usb_vfup_ctx_t *ctx, int offset,
	char *chunk, int size);
int pp_usb_vfup_complete(pp_usb_vfup_ctx_t *ctx);
int pp_usb_vfup_activate(pp_usb_vfup_ctx_t *ctx);

typedef struct pp_usb_smbmnt_ctx_s pp_usb_smbmnt_ctx_t;

typedef enum {
    PP_USB_SMBMNT_PARAM_HOST,
    PP_USB_SMBMNT_PARAM_SHARE,
    PP_USB_SMBMNT_PARAM_PATH,
    PP_USB_SMBMNT_PARAM_USER,
    PP_USB_SMBMNT_PARAM_PASS
} pp_usb_smbmnt_param_t;

typedef enum {
    PP_USB_SMBMNT_STATUS_IDLE,
    PP_USB_SMBMNT_STATUS_BUSY,
    PP_USB_SMBMNT_STATUS_SUCCESS,
    PP_USB_SMBMNT_STATUS_FAILED
} pp_usb_smbmnt_status_t;

pp_usb_smbmnt_ctx_t *pp_usb_smbmnt_start(int device_id);
int pp_usb_smbmnt_close(pp_usb_smbmnt_ctx_t *ctx);
void pp_usb_smbmnt_set_param(pp_usb_smbmnt_ctx_t *ctx,
	pp_usb_smbmnt_param_t param, const char *value);
int pp_usb_smbmnt_activate(pp_usb_smbmnt_ctx_t *ctx);
pp_usb_smbmnt_status_t pp_usb_smbmnt_get_status(pp_usb_smbmnt_ctx_t *ctx);

#ifdef __cplusplus
}
#endif

#endif /* ! __USBD_H__ */

