#ifndef __PP_WSMAN_H
#define __PP_WSMAN_H

#include <pp/base.h>

/* error values for web server */
#define PP_WSMAN_NO_ERROR		0
#define PP_WSMAN_FAULT			1
#define PP_WSMAN_ERROR_INTERNAL		2
#define PP_WSMAN_ERROR_AUTH_FAILED	3

/* initialize the WS-Management library */
int pp_wsman_init(void);

/* cleanup the WS-Management library */
void pp_wsman_cleanup(void);

/* process a WS-Management request */
int pp_wsman_process_request(char * auth_string,
			     char * request, size_t req_len,
			     char **response, size_t *resp_len,
			     int secure, int is_utf16);

#endif // __PP_WSMAN_H
