#include "debug.h"

#include "wsman.h"
#include "fault.h"
#include "resource.h"
#include "standard_actions.h"

#include "res_this.h"

#include "xml_writer.h"

#include "identify.h"

static int get_this_data(xml_writer_t, wsman_request_t *, wsman_instance_t *, int *, int *, char **);
static int get_this_data_fragment(xml_writer_t, wsman_request_t *, wsman_instance_t *, int *, int *, char **);
static wsman_instance_t * get_this_instance_first(wsman_resource_t *, wsman_request_t *, int *, const char *auth_string);
static wsman_instance_t * get_this_instance_req(wsman_resource_t *, wsman_request_t *, int *, const char *);

/******************************************************************************
* data                                                                        *
******************************************************************************/

static wsman_action_t this_act[] = {
    { ACTION_URI_GET, resource_get },
    { ACTION_URI_ENUMERATE, resource_enumerate },
    { ACTION_URI_RELEASE, resource_release },
    { ACTION_URI_PULL, resource_pull },
    { NULL, NULL }
};
static wsman_operation_t this_op[] = {
    {
    	wsdl_port:		NULL,
    	wsdl_ref:		NULL,
    	actions:		this_act,
    	selector_set_ref:	NULL,
    	option_set_ref:		NULL,
    	schema_ref:		NULL,
    	filter_dialects:	NULL,
    	filters_required:	0,
    	delivery_modes:		NULL,
    },
    {
    	wsdl_port:		NULL,
    	wsdl_ref:		NULL,
    	actions:		NULL,
    	selector_set_ref:	NULL,
    	option_set_ref:		NULL,
    	schema_ref:		NULL,
    	filter_dialects:	NULL,
    	filters_required:	0,
    	delivery_modes:		NULL,
    }
};

wsman_resource_t this_resource_02 = {
    resource_uri_namespace:	NAMESPACE_MANAGEMENT,
    resource_uri_ns_shortcut:	"wsman",
    resource_uri:		"system/2005/02/this",
    ops:			this_op,
    
    get_first_instance:		get_this_instance_first,
    get_instance_by_request:	get_this_instance_req,
    get_instance_data:		get_this_data,
    get_instance_data_fragment:	get_this_data_fragment,
};

wsman_resource_t this_resource_06 = {
    resource_uri_namespace:	NAMESPACE_MANAGEMENT,
    resource_uri:		"system/2005/06/this",
    ops:			this_op,
    
    get_first_instance:		get_this_instance_first,
    get_instance_by_request:	get_this_instance_req,
    get_instance_data:		get_this_data,
    get_instance_data_fragment:	get_this_data_fragment,
};

static wsman_instance_t this_instance_02;
static wsman_instance_t this_instance_06;

/******************************************************************************
* functions                                                                   *
******************************************************************************/

#define RETURN_ERROR(code, detail, det_str)	\
    do {					\
    	*fault_code = code;			\
    	*fault_detail = detail;			\
    	*fault_detail_string = det_str;		\
    	ret = -1;				\
    	goto bail;				\
    } while(0)

int this_init(void) {
    initialize_instance(&this_instance_02, &this_resource_02);
    initialize_instance(&this_instance_06, &this_resource_06);
    return (add_resource(&this_resource_02, 0) || add_resource(&this_resource_06, 0));
}

static wsman_instance_t * get_this_instance_first(wsman_resource_t *res, wsman_request_t *req UNUSED, int *is_last, const char *auth_string UNUSED) {
    *is_last = 1;
    return res == &this_resource_02 ? &this_instance_02 : &this_instance_06;
}

static wsman_instance_t * get_this_instance_req(wsman_resource_t *res, wsman_request_t *req UNUSED, int *fault UNUSED, const char *auth_string UNUSED) {
    return res == &this_resource_02 ? &this_instance_02 : &this_instance_06;
}

static char *get_this_element(char *req) {
    if (!strcasecmp(req, "Vendor")) {
    	return IDENTIFY_VENDOR;
    } else if (!strcasecmp(req, "Version")) {
    	return IDENTIFY_VERSION;
    }
    
    return NULL;
}

static int get_this_data(xml_writer_t xml, wsman_request_t *req UNUSED, wsman_instance_t * inst UNUSED,
			 int *f1 UNUSED, int *f2 UNUSED, char **f3 UNUSED) {
    xml_writer_t this;
    
    this = print_xml_tag(xml, "t", "This", NULL,
    	"xmlns", "t", "", NAMESPACE_MANAGEMENT "/this");
    print_xml_tag(this, "t", "Vendor", get_this_element("Vendor"), NULL);
    print_xml_tag(this, "t", "Version", get_this_element("Version"), NULL);
    
    return 0;
}

static int get_this_data_fragment(xml_writer_t xml, wsman_request_t *req, wsman_instance_t * inst UNUSED,
				  int *fault_code, int *fault_detail, char **fault_detail_string) {
    int ret = 0;
    char *elem;
    xml_writer_t frag;
    wsman_fragment_t *fragment;
    
    if (vector_size(req->fragment.fragments) != 2 ||
    	(fragment = (wsman_fragment_t *)vector_get(req->fragment.fragments, 0))->array_index ||
    	strcasecmp(fragment->fragment, "This") ||
    	(fragment = (wsman_fragment_t *)vector_get(req->fragment.fragments, 1))->array_index ||
    	!(elem = get_this_element(fragment->fragment))) {
    	
    	D(D_ERROR, "Fragment %s not found.\n", req->fragment.fragment_full);
    	RETURN_ERROR(FAULT_INVALID_REPRESENTATION, FAULT_DETAIL_REPRESENTATION_INVALID_FRAGMENT, 0);
    }
    
    frag = print_xml_tag(xml, "wsman", "XmlFragment", NULL, NULL);
    if (req->fragment.text_only) {
    	print_xml_text(frag, elem);
    } else {
    	print_xml_tag(frag, "", fragment->fragment, elem, NULL);
    }
    
 bail:
    return ret;
}
