/*
 *  linux/arch/arm/mach-faraday/platform-a320/fia320.c
 *
 *  Faraday A320D Platform Dependent Functions
 *
 *  Copyright (C) 2005 Faraday Corp. (http://www.faraday-tech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ChangeLog
 * 
 *  Luke Lee  09/26/2005  Created
 *  Peter Liao 09/29/2005 Port dynamically getting AHB clock
 */

#include <linux/config.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/pm.h>
#include <linux/sched.h>

#include <asm/cpu-single.h>
#include <asm/arch/system.h>

#ifdef CONFIG_PLATFORM_AHBDMA
#include <asm/arch/ahb_dma.h>
int (*platform_ahbdma_get_irq)(int base);
asmlinkage unsigned ahbdma_irq21_dispatch(unsigned irq)
{
	int irq_ret;
	if ( platform_ahbdma_get_irq == NULL ) {
		printk(KERN_ERR "Donot register ahb dma get irq func. pointer\n");
		return PLATFORM_INTERRUPTS;
	}
	irq_ret = platform_ahbdma_get_irq(DMAC_FTDMAC020_VA_BASE);
	if ( irq_ret >= 0 )
		return irq_ret + PLATFORM_AHBDMA_IRQ_BASE;
	else {
		printk(KERN_ERR "ahbdma_irq21_dispatch Error:irq=%d,map to %d\n",irq, platform_ahbdma_get_irq(DMAC_FTDMAC020_VA_BASE) + PLATFORM_AHBDMA_IRQ_BASE);
		return PLATFORM_INTERRUPTS;
	}
}
void register_ahbdma_get_irq_func(int (*func)(int base))
{
	platform_ahbdma_get_irq = func;
}
#endif

#ifdef CONFIG_PLATFORM_APBDMA
#include <asm/arch/apb_dma.h>
int (*platform_apbdma_get_irq)(int base);
asmlinkage unsigned apbdma_irq24_dispatch(unsigned irq)
{
	int irq_ret;
	if ( platform_apbdma_get_irq == NULL ) {
		printk(KERN_ERR "Donot register apb dma get irq func. pointer\n");
		return PLATFORM_INTERRUPTS;
	}
	irq_ret = platform_apbdma_get_irq(APBBRG_FTAPBBRG020S_0_VA_BASE);
	if ( irq_ret >= 0 )
		return irq_ret + PLATFORM_APBDMA_IRQ_BASE;
	else {
		printk(KERN_ERR "apbdma_irq24_dispatch Error:irq=%d,map to %d\n",irq, platform_apbdma_get_irq(APBBRG_FTAPBBRG020S_0_VA_BASE) + PLATFORM_AHBDMA_IRQ_BASE);
		return PLATFORM_INTERRUPTS;
	}
}
void register_apbdma_get_irq_func(int (*func)(int base))
{
	platform_apbdma_get_irq = func;
}
#endif



#ifdef CONFIG_AUTO_SYS_CLK
static unsigned int PMU_value2div(unsigned int val)
{
    switch(val) {
        case 0: return 2;
        case 1: return 3;
        case 2: return 4;
        case 3: return 6;
        case 4: return 8;
        default:
                printk("Unknown PMU divide value:%x\n", val);
                return 8;
    }
}
static unsigned getDivFactor(void)
{
        unsigned pmode;
        pmode=*(volatile unsigned int *)(PMU_FTPMU010_0_VA_BASE+0xc);
        pmode >>= 4;
        return PMU_value2div(pmode&0xf);
}
static int hasTurbo(void)
{
        unsigned pmode;
        pmode=*(volatile unsigned int *)(PMU_FTPMU010_0_VA_BASE+0xc);
        return ((pmode&0x2)==0x2);
}

/* HCLK and multiple in Hz*/
static unsigned int u32ReadHCLK(void)
{
    unsigned int hclk,mul;
    mul = ((*(unsigned int *)(PMU_FTPMU010_0_VA_BASE+0x30))>>3)&0x1ff;
    hclk=(36864U*mul+1)*100;
    return hclk;
}

int a320_get_ahb_clk(void)
{
        static unsigned ahb_clk=0;
        if(!ahb_clk) {   
                ahb_clk=u32ReadHCLK()/getDivFactor();
                printk("A320: Autodetected AHB Clock:");
                printk(" CPU/AHB=%dHz/%dHz/Div=%d\n", hasTurbo()?u32ReadHCLK():ahb_clk, ahb_clk, getDivFactor());
        }
        return ahb_clk;
}
#endif

/*
 * Our platform pm_idle() function is different from the default_idle()
 * in arch/arm/kernel/process.c.
 */

void fia320_default_idle(void)
{
	if (!need_resched())
		arch_idle();
}

static int __init fia320_pm_init(void)
{
        pm_idle = fia320_default_idle;
        return 0;
}

__initcall( fia320_pm_init );

#ifdef CONFIG_AUTO_SYS_CLK
EXPORT_SYMBOL(a320_get_ahb_clk);
EXPORT_SYMBOL(register_apbdma_get_irq_func);
EXPORT_SYMBOL(register_ahbdma_get_irq_func);
#endif
