/*
 *  linux/arch/arm/mach-faraday/platform.c
 *
 *  Platform Indepdenent Initialization
 *  
 *  Copyright (C) 2005 Faraday Corp. (http://www.faraday-tech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ChangeLog
 * 
 *  Luke Lee  09/13/2005  Created
 */

#include <linux/kernel.h>
#include <asm/mach-types.h>
#include <asm/types.h>
#include <asm/sizes.h>
#include <asm/setup.h>
#include <asm/mach/arch.h>
#include <asm/mach/map.h>

/*
 * Platform dependent and independent specifications
 */
#include <asm/arch/spec.h>
#include <asm/arch/intc.h>
#include <asm/arch/timer.h>

static void __init platform_map_io(void)
{
    struct map_desc* platform_io_desc;
    int platform_io_desc_size;

    platform_io_desc_get(&platform_io_desc, &platform_io_desc_size);
   
    iotable_init(platform_io_desc, platform_io_desc_size);
}

static void __init platform_fixup_memory(struct machine_desc *desc, struct tag *tags,
                                         char **cmdline, struct meminfo *mi)
{
    /* Note: this squashes tags possibly submitted from the
       boot code, remove this code if this is not desired */
    
#if CPU_MEM_PA_COUNT > 1
        int i;        
        mi->nr_banks      = CPU_MEM_PA_COUNT;
        for (i=0; i<CPU_MEM_PA_COUNT; i++) {
                /* FA series does not support SMP, only CPU0 is available */
                mi->bank[i].start = CPU_MEM_pa_base[0][i];
                mi->bank[i].size  = CPU_MEM_pa_size[0][i];
                mi->bank[i].node  = i;
        }
#else
        mi->nr_banks      = 1;
        mi->bank[0].start = CPU_MEM_PA_BASE;
        mi->bank[0].size  = CPU_MEM_PA_SIZE;
        mi->bank[0].node  = 0;        
#endif
}

MACHINE_START(FARADAY, PLATFORM_NAME)
    /* Maintainer : Faraday */
    .phys_ram       = CPU_MEM_PA_BASE,
    .phys_io        = PLATFORM_BOOTTIME_IO_PA_BASE,
    .io_pg_offst    = ((PLATFORM_BOOTTIME_IO_VA_BASE)>>18)&0xfffc,
    .boot_params    = BOOT_PARAMETER_PA_BASE,
    .map_io         = platform_map_io,
    .init_irq       = platform_init_irq,
    .fixup	    = platform_fixup_memory,
    .timer          = &platform_timer,       /* defined in timer.c */
MACHINE_END
