#define TEST_MASTER_WRITE	0
#define TEST_MASTER_READ	0
#define TEST_SMBUS_READ_BYTE	1

#if TEST_MASTER_WRITE
static int asicsi2c_master_send(struct i2c_adapter *adap, const char *buf, int count, unsigned int addr)
{
	int ret;
	struct i2c_msg msg;

	if (adap->algo->master_xfer) {
		msg.addr   = addr;
		msg.flags = 0;
		msg.len = count;
		msg.buf = (char *)buf;
	
		DBG("master_send: writing %d bytes.\n",	count);
	
		down(&adap->bus_lock);
		ret = adap->algo->master_xfer(adap,&msg,1);
		up(&adap->bus_lock);

		/* if everything went ok (i.e. 1 msg transmitted), return #bytes
		 * transmitted, else error code.
		 */
		return (ret == 1) ? count : ret;
	} else {
		ERR("I2C level transfers not supported\n");
		return -ENOSYS;
	}
}
#endif

#if TEST_MASTER_READ
static int asicsi2c_master_recv(struct i2c_adapter *adap, char *buf, int count, unsigned int addr)
{
	struct i2c_msg msg;
	int ret;
	if (adap->algo->master_xfer) {
		msg.addr   = addr;
		msg.flags = 0;
		msg.flags |= I2C_M_RD;
		msg.len = count;
		msg.buf = buf;

		DBG("master_recv: reading %d bytes.\n", count);
	
		down(&adap->bus_lock);
		ret = adap->algo->master_xfer(adap,&msg,1);
		up(&adap->bus_lock);
	
		DBG("master_recv: return:%d (count:%d, addr:0x%02x)\n",
			ret, count, addr);
	
		/* if everything went ok (i.e. 1 msg transmitted), return #bytes
	 	* transmitted, else error code.
	 	*/
		return (ret == 1) ? count : ret;
	} else {
		ERR("I2C level transfers not supported\n");
		return -ENOSYS;
	}
}
#endif

#if TEST_SMBUS_READ_BYTE
static int asicsi2c_smbus_read_byte(struct i2c_adapter *adap, unsigned char io_addr, unsigned int addr)
{
	struct i2c_msg msg[2];
	int ret;
	unsigned char read;
	if (adap->algo->master_xfer) {
		msg[0].addr   = addr;
		msg[0].flags = 0;
		msg[0].len = 1;
		msg[0].buf = (char *)&io_addr;
		
		msg[1].addr   = addr;
		msg[1].flags = 0;
		msg[1].flags |= I2C_M_RD;
		msg[1].len = 1;
		msg[1].buf = &read;

		DBG("smbus_read_byte: reading one byte from 0x%02x.\n", io_addr);
	
		down(&adap->bus_lock);
		ret = adap->algo->master_xfer(adap,msg,2);
		up(&adap->bus_lock);
	
		DBG("smbus_read_byte: return:%d (addr:0x%02x)\n", ret, addr);
	
		/* if everything went ok (i.e. 1 msg transmitted), return #bytes
	 	* transmitted, else error code.
	 	*/
		return (ret == 2) ? (read & 0xff) : ret;
	} else {
		ERR("I2C level transfers not supported\n");
		return -ENOSYS;
	}
}
#endif

static void send_some_messages(struct i2c_adapter *adap)
{
	int ret;
	char buf;
	
	DBG("\nSending some messages to debug the driver.\n\n");
	
#if TEST_MASTER_WRITE
	DBG("Sending one byte to the PowerPC.\n\n");
	ret = asicsi2c_master_send(adap, "xxxxxxx", 1, 0x55);
	if (ret < 0) {
		DBG("Error sending one byte to the PowerPC.\n\n");
		return;
	}
#endif

#if TEST_MASTER_READ
	DBG("Reading one byte from the PowerPC.\n\n");
	ret = asicsi2c_master_recv(adap, &buf, 1, 0x55);
	if (ret < 0) {
		DBG("Error sending one byte to the PowerPC.\n\n");
		return;
	} else {
		DBG("Read byte 0x%02x from PowerPC.\n\n", buf & 0xff);
	}
#endif

#if TEST_SMBUS_READ_BYTE
	DBG("Reading one byte from the ADC (SM-Bus.\n\n");
	ret = asicsi2c_smbus_read_byte(adap, 1, 0x4C);
	if (ret < 0) {
		DBG("Error sending one byte to the ADC.\n\n");
		return;
	} else {
		DBG("Read byte 0x%02x from ADC.\n\n", ret & 0xff);
	}
#endif
}
