/*   Copyright (C) 2004 Microtronix Datacom Ltd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		*/

#ifndef I2C_ASICS_H
#define I2C_ASICS_H 1

/* Register map */
#define REG_ASICSI2C_PRERL		0x00	/* prescale low register */
#define REG_ASICSI2C_PRERH		0x01	/* prescale high register */
#define REG_ASICSI2C_CCR		0x02	/* control/command register */
#define REG_ASICSI2C_SR			0x03	/* status register */
#define REG_ASICSI2C_DR			0x04	/* data register */
#define REG_ASICSI2C_SAR0		0x05 	/* slave address register */
#define REG_ASICSI2C_SAR1		0x06 	/* slave address register */
#define REG_ASICSI2C_SAR2		0x07 	/* slave address register */
#define REG_ASICSI2C_SAR3		0x08 	/* slave address register */
#define REG_ASICSI2C_SAR4		0x09 	/* slave address register */
#define REG_ASICSI2C_SAR5		0x0A	/* slave address register */
#define REG_ASICSI2C_SAR6		0x0B	/* slave address register */
#define REG_ASICSI2C_SAR7		0x0C	/* slave address register */
#define REG_ASICSI2C_ESAR		0x0D	/* extended address register */
#define REG_ASICSI2C_SEC_CMD		0x0E	/* second command register */

/* control/command register */
#define BIT_ASICSI2C_CC_ENA		(1<<7)	/* core enabled */
#define BIT_ASICSI2C_CC_IEN		(1<<6)	/* interrupt enabled */
#define BIT_ASICSI2C_CC_MS		(1<<5)	/* master/slave select */
#define BIT_ASICSI2C_CC_RSTA		(1<<4)	/* repeated start condition */
#define BIT_ASICSI2C_CC_RD		(1<<3)	/* read */
#define BIT_ASICSI2C_CC_WR		(1<<2)	/* write */
#define BIT_ASICSI2C_CC_T_NO_ACK	(1<<1)	/* transmit acknowledge */

/* second command register */
#define BIT_ASICSI2C_SCR_RESET		1	/* reset the core */

/* status register */
#define BIT_ASICSI2C_SR_TDONE		(1<<7)	/* transfer done */
#define BIT_ASICSI2C_SR_BSY		(1<<6)	/* bus busy */
#define BIT_ASICSI2C_SR_AL		(1<<5)	/* arbitration lost */
#define BIT_ASICSI2C_SR_CAS		(1<<4)	/* called as slave */
#define BIT_ASICSI2C_SR_DSP		(1<<3)	/* detected stop condition */
#define BIT_ASICSI2C_SR_SRW		(1<<2)	/* slave read/write */
#define BIT_ASICSI2C_SR_R_NO_ACK	(1<<1)	/* received ack */
#define BIT_ASICSI2C_SR_IF		1	/* interrupt flag */


#endif /* I2C_ASICS_H */
