/* ahb_dma.h */
#ifndef _AHB_DMA_H_
#define _AHB_DMA_H_

/* register definition */
#define AHBDMA_ISR	    0x0
#define AHBDMA_INT_TC	    0x1
#define AHBDMA_INT_TC_CLR   0x2
#define AHBDMA_INT_ERR	    0x3
#define AHBDMA_INT_ERR_CLR  0x4
#define AHBDMA_TC           0x5
#define AHBDMA_ERR          0x6
#define AHBDMA_CHANNEL_EN   0x7
#define AHBDMA_CHANNEL_BUSY 0x8
#define AHBDMA_CSR	    0x9
#define AHBDMA_SYNC         0xA

#define AHBDMA_CHANNEL_CSR	0x0
#define AHBDMA_CHANNEL_CFG	0x1
#define AHBDMA_CHANNEL_SRC	0x2
#define AHBDMA_CHANNEL_DST	0x3
#define AHBDMA_CHANNEL_LLP	0x4
#define AHBDMA_CHANNEL_TXSZ	0x5

#define AHBDMA_WIDTH_8BIT       0x0
#define AHBDMA_WIDTH_16BIT      0x1
#define AHBDMA_WIDTH_32BIT      0x2
#define AHBDMA_CTL_INC          0x0
#define AHBDMA_CTL_DEC          0x1
#define AHBDMA_CTL_FIX          0x2

#define AHBDMA_MASTER_0         0x0
#define AHBDMA_MASTER_1         0x1

#define AHBDMA_NO_TRIGGER_IRQ   0x0
#define AHBDMA_TRIGGER_IRQ      0x1    //john

//john add for interrupt status, error
#define INT_TRIGGER 0x01
#define INT_ERROR   0x02

#define AHB_DMA_MAX_CHANNELS	8

typedef void (*ahb_dma_irq_handler_t) (void *isr_data);

typedef struct
{
	unsigned int source;
	unsigned int dest;
	u32          *llp;
	unsigned int control;
} ahb_lld_t;

typedef struct
{
    /* add dma parameter */
    unsigned int    src;        //source address for dma
    unsigned int    dest;       //dest address for dma
    unsigned int    sw;         //source width (0/1/2=>8/16/32)
    unsigned int    dw;         //dest width (0/1/2=>8/16/32)
    unsigned int    sctl;       //source control (0/1/2/3=>inc/dec/fix/x)
    unsigned int    dctl;       // dest coontrol (0/1/2/3=>inc/dec/fix/x)
    unsigned int    src_data_master;//0,1
    unsigned int    dest_data_master;//0,1
    unsigned int    size;       // dma count
    unsigned int    irq;        // (0/1)==>(disable/enable)
} ahb_dma_parm_t;

typedef struct
{
    volatile u32    *base;
    unsigned int    channel;
    unsigned int    status;
    unsigned int    llp_master; //0,1
    unsigned int    llp_count;
    unsigned int    hw_handshake;
    unsigned int    llp_last_idx;   //0(register),1(first llp),2(second llp),3...
    unsigned int    llp_free_idx;   //0(register),1(first llp),2(second llp),3...    
    ahb_lld_t       *ahb_dma_lld;
    ahb_lld_t       *ahb_dma_lld_phys;
} ahb_dma_channel_data_t;

typedef struct
{
    /* init parameter */
    volatile u32    *base;
    u8              channel_used[AHB_DMA_MAX_CHANNELS];
    ahb_dma_channel_data_t *data[AHB_DMA_MAX_CHANNELS];
    ahb_dma_irq_handler_t irq_handler[AHB_DMA_MAX_CHANNELS];
    void            *isr_data[AHB_DMA_MAX_CHANNELS];
    u32             active_channels;
    u8  	    irq_requested;
} ahb_dma_data_t;

int ahb_dma_request_channel(ahb_dma_irq_handler_t irq_handler, void *isr_data, int llp_count, ahb_dma_channel_data_t **channel_data);
void ahb_dma_release_channel(ahb_dma_channel_data_t **channel_data);
void ahb_dma_channel_add(ahb_dma_channel_data_t *priv, ahb_dma_parm_t *parm);
void ahb_dma_channel_start(ahb_dma_channel_data_t *priv);
void ahb_dma_channel_reset(ahb_dma_channel_data_t *priv);

#endif
