/*
 *  linux/include/asm-arm/arch-faraday/memory.h
 *  
 *  Faraday Platform Independent Memory Configuration
 *  
 *  Copyright (C) 2005 Faraday Corp. (http://www.faraday-tech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *  
 * ChangeLog
 *
 *  Luke Lee  09/16/2005  Created.
 */

#ifndef __FARADAY_PLATFORM_INDEPENDENT_MEMORY_HEADER__
#define __FARADAY_PLATFORM_INDEPENDENT_MEMORY_HEADER__

#include <asm/arch/spec.h>
/* Include platform *dependent* memory configuration */
#include <asm/arch/platform/memory.h>

#ifndef PHYS_OFFSET
#define PHYS_OFFSET     CPU_MEM_PA_BASE
#endif

#ifndef PAGE_OFFSET
#define PAGE_OFFSET     (0xC0000000UL)
#endif

#ifndef END_MEM
#define END_MEM         (CPU_MEM_PA_LIMIT)
#endif

#ifndef __virt_to_bus
#define __virt_to_bus(x)	(x - PAGE_OFFSET)
#endif

#ifndef __bus_to_virt
#define __bus_to_virt(x)	(x + PAGE_OFFSET)
#endif

#endif /* __FARADAY_PLATFORM_INDEPENDENT_MEMORY_HEADER__ */
