#ifndef __ASM_PEPPERCON_H__
#define __ASM_PEPPERCON_H__

#include <asm/arch/platform-a320/kira100.h>

/* TODO (miba): after switching to 2.6 put pp_gpio driver in the kernel and remove this */
extern spinlock_t pp_kira_gpio_lock;

extern int pp_time_init(void);
#ifdef PP_FEAT_SYSOK_BLINKING
extern void pp_status_led_blinking(unsigned char blinking);
#endif

/**
 * function which determines the revision of KIRA100
 */

extern uint32_t pp_kira_get_revision(void);

/**
 * functions to access KIRA PMU registers, should be
 * used by all drivers doing this so we can assure locking
 */

extern uint32_t pp_kira_get_pmu_reg(int reg);
extern void pp_kira_set_pmu_reg(int reg, uint32_t val);
extern uint32_t pp_kira_get_pmu_reg_bits(int reg, uint32_t mask);
extern void pp_kira_set_pmu_reg_bits(int reg, uint32_t set_mask, uint32_t clr_mask);

#endif /* __ASM_PEPPERCON_H__ */
