/*
 *  linux/include/asm-arm/arch-faraday/platform-kira100/spec.h
 *
 *  Faraday Platform Specification  (Automatically generated by "autospec", do not edit)
 *
 *  Copyright (C) 2006 Faraday Corp. (http://www.faraday-tech.com)
 *
 *  Platform Hierarchy :
 *
 *    KIRA100
 *     +- CPU_FA526  (0)
 *     +- INTC_FTINTC010  (0)
 *     +- UART_FTUART010  (0)
 *     +- UART_FTUART010  (1)
 *     +- UART_FTUART010  (2)
 *     +- TIMER_FTTMR010  (0)
 *     +- PMU_FTPMU010  (0)
 *     +- MAC_FTMAC100  (0)
 *     +- SDC_FTSDC010  (0)
 *     +- AHBDMA
 *     |   +- DMAC_FTDMAC020  (0)
 *     +- APBDMA
 *         +- APBBRG_FTAPBBRG020S  (0)
 */

#ifndef __KIRA100_PLATFORM_SPECIFICATION__
#define __KIRA100_PLATFORM_SPECIFICATION__

#include <asm/arch/platform/kira100.h>

#define PLATFORM_NAME	"Faraday KIRA100"

/*
 * Component counts
 */

/* CPU */
#define CPU_COUNT	1
#define CPU_FA526_COUNT	1
/* INTC */
#define INTC_COUNT	1
#define INTC_FTINTC010_COUNT	1
/* UART */
#define UART_COUNT	2
#define UART_FTUART010_COUNT	2
/* TIMER */
#define TIMER_COUNT	1
#define TIMER_FTTMR010_COUNT	1
/* PMU */
#define PMU_COUNT	1
#define PMU_FTPMU010_COUNT	1
/* MAC */
#define MAC_COUNT	1
#define MAC_FTMAC100_COUNT	1
/* SDC */
#define SDC_COUNT	1
#define SDC_FTSDC010_COUNT	1
/* AHBDMA */
#define AHBDMA_COUNT	1
/* APBDMA */
#define APBDMA_COUNT	1
/* DMAC */
#define DMAC_COUNT	1
#define DMAC_FTDMAC020_COUNT	1
/* APBBRG */
#define APBBRG_COUNT	1
#define APBBRG_FTAPBBRG020S_COUNT	1

/*
 * Hierarchial Component IDs
 */

#define PLATFORM_AHBDMA_DMAC_FTDMAC020_ID	0
#define PLATFORM_APBDMA_APBBRG_FTAPBBRG020S_ID	0

/*
 * Number of interrupts, including IRQ and FIQ
 */

#define PLATFORM_IRQ_TOTALCOUNT	32
#define PLATFORM_FIQ_TOTALCOUNT	32
#define PLATFORM_AHBDMA_IRQ_TOTALCOUNT	8
#define PLATFORM_AHBDMA_FIQ_TOTALCOUNT	0
#define PLATFORM_APBDMA_IRQ_TOTALCOUNT	4
#define PLATFORM_APBDMA_FIQ_TOTALCOUNT	0

#define PLATFORM_IRQ_BASE	0
#define PLATFORM_FIQ_BASE	32
#define PLATFORM_AHBDMA_IRQ_BASE	64
#define PLATFORM_APBDMA_IRQ_BASE	72
#define PLATFORM_INTERRUPTS	76

/*
 * IRQ/FIQ trigger level and trigger mode
 */

#define PLATFORM_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_FIQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_AHBDMA_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_AHBDMA_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_AHBDMA_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_AHBDMA_FIQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_APBDMA_IRQ_TRIGGER_MODE	0x00000000
#define PLATFORM_APBDMA_IRQ_TRIGGER_LEVEL	0xFFFFFFFF
#define PLATFORM_APBDMA_FIQ_TRIGGER_MODE	0x00000000
#define PLATFORM_APBDMA_FIQ_TRIGGER_LEVEL	0xFFFFFFFF

/*
 * Interrupt numbers of Hierarchical Architecture
 */

/* AHBDMA */
#define PLATFORM_AHBDMA_IRQ	21

/* APBDMA */
#define PLATFORM_APBDMA_IRQ	24


/*
 * Interrrupt numbers
 */

/* UART */
#define UART_FTUART010_IRQ_COUNT	1
#define UART_FTUART010_IRQ	10
#define UART_FTUART010_0_IRQ	10
//#define UART_FTUART010_1_IRQ	11
#define UART_FTUART010_2_IRQ	7

/* TIMER */
#define TIMER_FTTMR010_IRQ_COUNT	1
#define TIMER_FTTMR010_IRQ	14
#define TIMER_FTTMR010_0_IRQ	14

/* MAC */
#define MAC_FTMAC100_IRQ_COUNT	1
#define MAC_FTMAC100_IRQ	19
#define MAC_FTMAC100_0_IRQ	19

/* SDC */
#define SDC_FTSDC010_IRQ_COUNT	1
#define SDC_FTSDC010_IRQ	5
#define SDC_FTSDC010_0_IRQ	5

/* DMAC */
#define DMAC_FTDMAC020_IRQ_COUNT	8
#define DMAC_FTDMAC020_IRQ0	64
#define DMAC_FTDMAC020_0_IRQ0	64
#define DMAC_FTDMAC020_IRQ1	65
#define DMAC_FTDMAC020_0_IRQ1	65
#define DMAC_FTDMAC020_IRQ2	66
#define DMAC_FTDMAC020_0_IRQ2	66
#define DMAC_FTDMAC020_IRQ3	67
#define DMAC_FTDMAC020_0_IRQ3	67
#define DMAC_FTDMAC020_IRQ4	68
#define DMAC_FTDMAC020_0_IRQ4	68
#define DMAC_FTDMAC020_IRQ5	69
#define DMAC_FTDMAC020_0_IRQ5	69
#define DMAC_FTDMAC020_IRQ6	70
#define DMAC_FTDMAC020_0_IRQ6	70
#define DMAC_FTDMAC020_IRQ7	71
#define DMAC_FTDMAC020_0_IRQ7	71

/* APBBRG */
#define APBBRG_FTAPBBRG020S_IRQ_COUNT	4
#define APBBRG_FTAPBBRG020S_IRQ0	72
#define APBBRG_FTAPBBRG020S_0_IRQ0	72
#define APBBRG_FTAPBBRG020S_IRQ1	73
#define APBBRG_FTAPBBRG020S_0_IRQ1	73
#define APBBRG_FTAPBBRG020S_IRQ2	74
#define APBBRG_FTAPBBRG020S_0_IRQ2	74
#define APBBRG_FTAPBBRG020S_IRQ3	75
#define APBBRG_FTAPBBRG020S_0_IRQ3	75

/*
 * Base addresses
 */

/* CPU */
#define CPU_MEM_PA_COUNT	1
#define CPU_MEM_PA_BASE		0x00000000
#define CPU_MEM_PA_LIMIT	CPU_MEM_PA_SIZE
#define CPU_MEM_PA_SIZE		0x02000000
#define CPU_MEM_0_PA_BASE	0x00000000
#define CPU_MEM_0_PA_LIMIT	CPU_MEM_0_PA_SIZE
#define CPU_MEM_0_PA_SIZE	0x02000000

/* INTC */
#define INTC_FTINTC010_PA_COUNT	1
#define INTC_FTINTC010_PA_BASE	0x98800000
#define INTC_FTINTC010_PA_LIMIT	0x988FFFFF
#define INTC_FTINTC010_PA_SIZE	0x00100000
#define INTC_FTINTC010_0_PA_BASE	0x98800000
#define INTC_FTINTC010_0_PA_LIMIT	0x988FFFFF
#define INTC_FTINTC010_0_PA_SIZE	0x00100000
#define INTC_FTINTC010_VA_COUNT	1
#define INTC_FTINTC010_VA_BASE	0xF9880000
#define INTC_FTINTC010_VA_LIMIT	0xF9880FFF
#define INTC_FTINTC010_VA_SIZE	0x00001000
#define INTC_FTINTC010_0_VA_BASE	0xF9880000
#define INTC_FTINTC010_0_VA_LIMIT	0xF9880FFF
#define INTC_FTINTC010_0_VA_SIZE	0x00001000

/* UART */
#define UART_FTUART010_PA_COUNT	1
#define UART_FTUART010_PA_BASE	0x98200000
#define UART_FTUART010_PA_LIMIT	0x982FFFFF
#define UART_FTUART010_PA_SIZE	0x00100000
#define UART_FTUART010_0_PA_BASE	0x98200000
#define UART_FTUART010_0_PA_LIMIT	0x982FFFFF
#define UART_FTUART010_0_PA_SIZE	0x00100000
//#define UART_FTUART010_1_PA_BASE	0x98300000
//#define UART_FTUART010_1_PA_LIMIT	0x983FFFFF
//#define UART_FTUART010_1_PA_SIZE	0x00100000
#define UART_FTUART010_2_PA_BASE	0x99600000
#define UART_FTUART010_2_PA_LIMIT	0x996FFFFF
#define UART_FTUART010_2_PA_SIZE	0x00100000
#define UART_FTUART010_VA_COUNT	1
#define UART_FTUART010_VA_BASE	0xF9820000
#define UART_FTUART010_VA_LIMIT	0xF9820FFF
#define UART_FTUART010_VA_SIZE	0x00001000
#define UART_FTUART010_0_VA_BASE	0xF9820000
#define UART_FTUART010_0_VA_LIMIT	0xF9820FFF
#define UART_FTUART010_0_VA_SIZE	0x00001000
//#define UART_FTUART010_1_VA_BASE	0xF9830000
//#define UART_FTUART010_1_VA_LIMIT	0xF9830FFF
//#define UART_FTUART010_1_VA_SIZE	0x00001000
#define UART_FTUART010_2_VA_BASE	0xF9960000
#define UART_FTUART010_2_VA_LIMIT	0xF9960FFF
#define UART_FTUART010_2_VA_SIZE	0x00001000

/* TIMER */
#define TIMER_FTTMR010_PA_COUNT	1
#define TIMER_FTTMR010_PA_BASE	0x98400000
#define TIMER_FTTMR010_PA_LIMIT	0x9840000F
#define TIMER_FTTMR010_PA_SIZE	0x00000010
#define TIMER_FTTMR010_0_PA_BASE	0x98400000
#define TIMER_FTTMR010_0_PA_LIMIT	0x9840000F
#define TIMER_FTTMR010_0_PA_SIZE	0x00000010
#define TIMER_FTTMR010_VA_COUNT	1
#define TIMER_FTTMR010_VA_BASE	0xF9840000
#define TIMER_FTTMR010_VA_LIMIT	0xF9840FFF
#define TIMER_FTTMR010_VA_SIZE	0x00001000
#define TIMER_FTTMR010_0_VA_BASE	0xF9840000
#define TIMER_FTTMR010_0_VA_LIMIT	0xF9840FFF
#define TIMER_FTTMR010_0_VA_SIZE	0x00001000

/* PMU */
#define PMU_FTPMU010_PA_COUNT	1
#define PMU_FTPMU010_PA_BASE	0x98100000
#define PMU_FTPMU010_PA_LIMIT	0x981FFFFF
#define PMU_FTPMU010_PA_SIZE	0x00100000
#define PMU_FTPMU010_0_PA_BASE	0x98100000
#define PMU_FTPMU010_0_PA_LIMIT	0x981FFFFF
#define PMU_FTPMU010_0_PA_SIZE	0x00100000
#define PMU_FTPMU010_VA_COUNT	1
#define PMU_FTPMU010_VA_BASE	0xF9810000
#define PMU_FTPMU010_VA_LIMIT	0xF9810FFF
#define PMU_FTPMU010_VA_SIZE	0x00001000
#define PMU_FTPMU010_0_VA_BASE	0xF9810000
#define PMU_FTPMU010_0_VA_LIMIT	0xF9810FFF
#define PMU_FTPMU010_0_VA_SIZE	0x00001000

/* MAC */
#define MAC_FTMAC100_PA_COUNT	1
#define MAC_FTMAC100_PA_BASE	0x90900000
#define MAC_FTMAC100_PA_LIMIT	0x909FFFFF
#define MAC_FTMAC100_PA_SIZE	0x00100000
#define MAC_FTMAC100_0_PA_BASE	0x90900000
#define MAC_FTMAC100_0_PA_LIMIT	0x909FFFFF
#define MAC_FTMAC100_0_PA_SIZE	0x00100000
#define MAC_FTMAC100_VA_COUNT	1
#define MAC_FTMAC100_VA_BASE	0xF9090000
#define MAC_FTMAC100_VA_LIMIT	0xF9090FFF
#define MAC_FTMAC100_VA_SIZE	0x00001000
#define MAC_FTMAC100_0_VA_BASE	0xF9090000
#define MAC_FTMAC100_0_VA_LIMIT	0xF9090FFF
#define MAC_FTMAC100_0_VA_SIZE	0x00001000

/* SDC */
#define SDC_FTSDC010_PA_COUNT	1
#define SDC_FTSDC010_PA_BASE	0x98E00000
#define SDC_FTSDC010_PA_LIMIT	0x98EFFFFF
#define SDC_FTSDC010_PA_SIZE	0x00100000
#define SDC_FTSDC010_0_PA_BASE	0x98E00000
#define SDC_FTSDC010_0_PA_LIMIT	0x98EFFFFF
#define SDC_FTSDC010_0_PA_SIZE	0x00100000
#define SDC_FTSDC010_VA_COUNT	1
#define SDC_FTSDC010_VA_BASE	0xF98E0000
#define SDC_FTSDC010_VA_LIMIT	0xF98E0FFF
#define SDC_FTSDC010_VA_SIZE	0x00001000
#define SDC_FTSDC010_0_VA_BASE	0xF98E0000
#define SDC_FTSDC010_0_VA_LIMIT	0xF98E0FFF
#define SDC_FTSDC010_0_VA_SIZE	0x00001000

/* DMAC */
#define DMAC_FTDMAC020_PA_COUNT	1
#define DMAC_FTDMAC020_PA_BASE	0x90400000
#define DMAC_FTDMAC020_PA_LIMIT	0x904FFFFF
#define DMAC_FTDMAC020_PA_SIZE	0x00100000
#define DMAC_FTDMAC020_0_PA_BASE	0x90400000
#define DMAC_FTDMAC020_0_PA_LIMIT	0x904FFFFF
#define DMAC_FTDMAC020_0_PA_SIZE	0x00100000
#define DMAC_FTDMAC020_VA_COUNT	1
#define DMAC_FTDMAC020_VA_BASE	0xF9040000
#define DMAC_FTDMAC020_VA_LIMIT	0xF9040FFF
#define DMAC_FTDMAC020_VA_SIZE	0x00001000
#define DMAC_FTDMAC020_0_VA_BASE	0xF9040000
#define DMAC_FTDMAC020_0_VA_LIMIT	0xF9040FFF
#define DMAC_FTDMAC020_0_VA_SIZE	0x00001000

/* APBBRG */
#define APBBRG_FTAPBBRG020S_PA_COUNT	1
#define APBBRG_FTAPBBRG020S_PA_BASE	0x90500000
#define APBBRG_FTAPBBRG020S_PA_LIMIT	0x905FFFFF
#define APBBRG_FTAPBBRG020S_PA_SIZE	0x00100000
#define APBBRG_FTAPBBRG020S_0_PA_BASE	0x90500000
#define APBBRG_FTAPBBRG020S_0_PA_LIMIT	0x905FFFFF
#define APBBRG_FTAPBBRG020S_0_PA_SIZE	0x00100000
#define APBBRG_FTAPBBRG020S_VA_COUNT	1
#define APBBRG_FTAPBBRG020S_VA_BASE	0xF9050000
#define APBBRG_FTAPBBRG020S_VA_LIMIT	0xF9050FFF
#define APBBRG_FTAPBBRG020S_VA_SIZE	0x00001000
#define APBBRG_FTAPBBRG020S_0_VA_BASE	0xF9050000
#define APBBRG_FTAPBBRG020S_0_VA_LIMIT	0xF9050FFF
#define APBBRG_FTAPBBRG020S_0_VA_SIZE	0x00001000

#ifdef CONFIG_PLATFORM_AHBDMA_MODULE
#define CONFIG_PLATFORM_AHBDMA
#endif

#ifdef CONFIG_PLATFORM_AHBDMA
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif

#ifdef CONFIG_PLATFORM_APBDMA_MODULE
#define CONFIG_PLATFORM_APBDMA
#endif

#ifdef CONFIG_PLATFORM_APBDMA
/* #undef FIQ_DISPATCH_TABLE */
#define IRQ_DISPATCH_TABLE 1
#endif


/*****************************************************************
 Virtual addresses
*****************************************************************/

#define CPE_AHB_VA_BASE		IO_ADDRESS(CPE_AHB_BASE)
#define CPE_AHBDMA_VA_BASE	IO_ADDRESS(CPE_AHBDMA_BASE)
#define CPE_APBDMA_VA_BASE	IO_ADDRESS(CPE_APBDMA_BASE)
#define CPE_PMU_VA_BASE		IO_ADDRESS(CPE_PMU_BASE)
#define CPE_UART1_VA_BASE	IO_ADDRESS(CPE_UART1_BASE)
#define CPE_UART3_VA_BASE	IO_ADDRESS(CPE_UART3_BASE)
#define CPE_TIMER_VA_BASE	IO_ADDRESS(CPE_TIMER_BASE)
#define CPE_WDT_VA_BASE		IO_ADDRESS(CPE_WDT_BASE)
#define CPE_RTC_VA_BASE   	IO_ADDRESS(CPE_RTC_BASE)
#define CPE_GPIO_VA_BASE        IO_ADDRESS(CPE_GPIO_BASE)
#define CPE_IC_VA_BASE          IO_ADDRESS(CPE_IC_BASE)
#define CPE_FTMAC_VA_BASE	IO_ADDRESS(CPE_FTMAC_BASE)
#define CPE_FTMAC2_VA_BASE	IO_ADDRESS(CPE_FTMAC2_BASE)  //2nd MAC
#define CPE_SSP_VA_BASE		IO_ADDRESS(CPE_SSP_BASE)
#define CPE_A321_IC_VA_BASE	IO_ADDRESS(CPE_A321_IC_BASE)
#define CPE_PCI_VA_BASE		IO_ADDRESS(CPE_PCI_BASE)
#define CPE_PCI_VA_MEM		IO_ADDRESS(CPE_PCI_MEM)
#define CPE_HOST20_VA_BASE	IO_ADDRESS(CPE_HOST20_BASE)
#define CPE_KBD_VA_BASE		IO_ADDRESS(CPE_KBD_BASE)
#define CPE_USBDEV_VA_BASE	IO_ADDRESS(CPE_USBDEV_BASE)
#define CPE_MOUSE_VA_BASE	IO_ADDRESS(CPE_MOUSE_BASE)
#define CPE_LCD_VA_BASE		IO_ADDRESS(CPE_LCD_BASE)
#define CPE_SD_VA_BASE		IO_ADDRESS(CPE_SD_BASE)   //SD
#define CPE_I2C1_VA_BASE	IO_ADDRESS(CPE_I2C1_BASE)
#define CPE_I2C2_VA_BASE	IO_ADDRESS(CPE_I2C2_BASE)
#define CPE_I2C3_VA_BASE	IO_ADDRESS(CPE_I2C3_BASE)
#define CPE_I2C4_VA_BASE	IO_ADDRESS(CPE_I2C4_BASE)
#define CPE_I2C5_VA_BASE	IO_ADDRESS(CPE_I2C5_BASE)
#define CPE_VSCREG_VA_BASE	IO_ADDRESS(CPE_VSCREG_BASE)
#define CPE_VSC_VA_BASE	        CPE_VSCREG_VA_BASE
#define CPE_VSCFB_VA_BASE	IO_ADDRESS(CPE_VSCFB_BASE)
#define CPE_PWM_VA_BASE		IO_ADDRESS(CPE_PWM_BASE)
#define CPE_AES_VA_BASE		IO_ADDRESS(CPE_AES_BASE)
#define CPE_LPC_VA_BASE		IO_ADDRESS(CPE_LPC_BASE)
#define CPE_FML_VA_BASE		IO_ADDRESS(CPE_FML_BASE)

/*****************************************************************
    IO Mapping
*****************************************************************/

#define IO_BASE	                        0xf0000000
#define MEM_ADDRESS(x)                  ((x&0x0fffffff)+IO_BASE)
#define IO_ADDRESS(x)                   (((x>>4)&0xffff0000)+(x&0xffff)+IO_BASE) 
#define PHY_ADDRESS(x)                  (((x<<4)&0xfff00000)+(x&0xffff))

/*
 * C definitions
 */
#if !defined(__ASSEMBLER__) && !defined(__ASSEMBLY__)

#include <asm/mach/map.h>
#include <linux/linkage.h>

typedef asmlinkage unsigned interrupt_dispatch_function(unsigned);

#ifdef CONFIG_PLATFORM_APBDMA
extern interrupt_dispatch_function apbdma_irq24_dispatch;
#else
#define apbdma_irq24_dispatch 0
#endif

#ifdef CONFIG_PLATFORM_AHBDMA
extern interrupt_dispatch_function ahbdma_irq21_dispatch;
#else
#define ahbdma_irq21_dispatch 0
#endif

/*
 * Interrrupt numbers
 */

/* UART */
extern const unsigned char UART_FTUART010_irq[UART_FTUART010_COUNT];
/* TIMER */
extern const unsigned char TIMER_FTTMR010_irq[TIMER_FTTMR010_COUNT];
/* MAC */
extern const unsigned char MAC_FTMAC100_irq[MAC_FTMAC100_COUNT];
/* SDC */
extern const unsigned char SDC_FTSDC010_irq[SDC_FTSDC010_COUNT];
/* DMAC */
extern const unsigned char DMAC_FTDMAC020_irq[DMAC_FTDMAC020_COUNT][DMAC_FTDMAC020_IRQ_COUNT];
/* APBBRG */
extern const unsigned char APBBRG_FTAPBBRG020S_irq[APBBRG_FTAPBBRG020S_COUNT][APBBRG_FTAPBBRG020S_IRQ_COUNT];

/*
 * Base addresses
 */

/* CPU */
extern const unsigned CPU_MEM_pa_base[CPU_MEM_PA_COUNT];
extern const unsigned CPU_MEM_pa_limit[CPU_MEM_PA_COUNT];
extern const unsigned CPU_MEM_pa_size[CPU_MEM_PA_COUNT];
/* INTC */
extern const unsigned INTC_FTINTC010_pa_base[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_pa_limit[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_pa_size[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_base[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_limit[INTC_FTINTC010_COUNT];
extern const unsigned INTC_FTINTC010_va_size[INTC_FTINTC010_COUNT];
/* UART */
extern const unsigned UART_FTUART010_pa_base[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_pa_limit[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_pa_size[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_base[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_limit[UART_FTUART010_COUNT];
extern const unsigned UART_FTUART010_va_size[UART_FTUART010_COUNT];
/* TIMER */
extern const unsigned TIMER_FTTMR010_pa_base[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_pa_limit[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_pa_size[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_base[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_limit[TIMER_FTTMR010_COUNT];
extern const unsigned TIMER_FTTMR010_va_size[TIMER_FTTMR010_COUNT];
/* PMU */
extern const unsigned PMU_FTPMU010_pa_base[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_pa_limit[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_pa_size[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_va_base[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_va_limit[PMU_FTPMU010_COUNT];
extern const unsigned PMU_FTPMU010_va_size[PMU_FTPMU010_COUNT];
/* MAC */
extern const unsigned MAC_FTMAC100_pa_base[MAC_FTMAC100_COUNT];
extern const unsigned MAC_FTMAC100_pa_limit[MAC_FTMAC100_COUNT];
extern const unsigned MAC_FTMAC100_pa_size[MAC_FTMAC100_COUNT];
extern const unsigned MAC_FTMAC100_va_base[MAC_FTMAC100_COUNT];
extern const unsigned MAC_FTMAC100_va_limit[MAC_FTMAC100_COUNT];
extern const unsigned MAC_FTMAC100_va_size[MAC_FTMAC100_COUNT];
/* SDC */
extern const unsigned SDC_FTSDC010_pa_base[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_pa_limit[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_pa_size[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_va_base[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_va_limit[SDC_FTSDC010_COUNT];
extern const unsigned SDC_FTSDC010_va_size[SDC_FTSDC010_COUNT];
/* DMAC */
extern const unsigned DMAC_FTDMAC020_pa_base[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_pa_limit[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_pa_size[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_base[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_limit[DMAC_FTDMAC020_COUNT];
extern const unsigned DMAC_FTDMAC020_va_size[DMAC_FTDMAC020_COUNT];
/* APBBRG */
extern const unsigned APBBRG_FTAPBBRG020S_pa_base[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_pa_limit[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_pa_size[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_va_base[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_va_limit[APBBRG_FTAPBBRG020S_COUNT];
extern const unsigned APBBRG_FTAPBBRG020S_va_size[APBBRG_FTAPBBRG020S_COUNT];

/* IO mapping */
struct map_desc;
extern void platform_io_desc_get(struct map_desc **desc, int *size);

#endif /* !defined(__ASSEMBLER__) && !defined(__ASSEMBLY__) */

#endif /* __KIRA100_PLATFORM_SPECIFICATION__ */

