/*
 *  linux/include/asm-arm/arch-faraday/serial.h
 *  
 *  Platform Independent UART Console Configuration
 *  
 *  Copyright (C) 2005 Faraday Corp. (http://www.faraday-tech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *  
 * Note
 *
 *  The first UART (FTUART010) in the system is used as the console.
 * 
 * ChangeLog
 *
 *  Luke Lee  09/15/2005  Created.
 */

#ifndef __FARADAY_PLATFORM_INDEPENDENT_SERIAL_HEADER__
#define __FARADAY_PLATFORM_INDEPENDENT_SERIAL_HEADER__

#ifndef __ASSEMBLY__

#include <linux/serial.h>
#include <asm/arch/spec.h>
/* Include platform *dependent* UART console configuration */
#include <asm/arch/platform/serial.h>

#ifndef STD_COM_FLAGS
#define STD_COM_FLAGS  (ASYNC_BOOT_AUTOCONF | ASYNC_SKIP_TEST)
#endif

#ifndef PLATFORM_MORE_SERIAL_PORTS
#define PLATFORM_MORE_SERIAL_PORTS
#endif

#ifndef SERIAL_PORT_DFNS
     /* UART CLK        PORT                 IRQ                 FLAGS          hub6 io_type iomem_base reg_shift*/
#define SERIAL_PORT_DFNS	\
     { 0, BASE_BAUD, UART_FTUART010_VA_BASE, UART_FTUART010_IRQ, STD_COM_FLAGS,   0,    0,     NULL,       2 }, /* ttyS0 */ \
     PLATFORM_MORE_SERIAL_PORTS
#endif

#endif /* __ASSEMBLY__ */

/*
 * UART FTUART010 registers
 */
#define SERIAL_THR                     	0x00	 		/*  Transmitter Holding Register(Write).*/
#define SERIAL_RBR                     	0x00	 		/*  Receive Buffer register (Read).*/
#define SERIAL_IER                     	0x04	 		/*  Interrupt Enable register.*/
#define SERIAL_IIR                     	0x08	 		/*  Interrupt Identification register(Read).*/
#define SERIAL_FCR                     	0x08	 		/*  FIFO control register(Write).*/
#define SERIAL_LCR                     	0x0C	 		/*  Line Control register.*/
#define SERIAL_MCR                     	0x10	 		/*  Modem Control Register.*/
#define SERIAL_LSR                     	0x14	 		/*  Line status register(Read) .*/
#define SERIAL_MSR                     	0x18	 		/*  Modem Status register (Read).*/
#define SERIAL_SPR                     	0x1C     		/*  Scratch pad register */
#define SERIAL_DLL                     	0x0      		/*  Divisor Register LSB */
#define SERIAL_DLM                     	0x4      		/*  Divisor Register MSB */
#define SERIAL_PSR                     	0x8     		/* Prescale Divison Factor */

/*
 * LSR Register bits
 */
#define SERIAL_LSR_DR                  0x1      	/* Data Ready */
#define SERIAL_LSR_OE                  0x2      	/* Overrun Error */
#define SERIAL_LSR_PE                  0x4      	/* Parity Error */
#define SERIAL_LSR_FE                  0x8      	/* Framing Error */
#define SERIAL_LSR_BI                  0x10     	/* Break Interrupt */
#define SERIAL_LSR_THRE                0x20     	/* THR Empty */
#define SERIAL_LSR_TE                  0x40     	/* Transmitte Empty */
#define SERIAL_LSR_DE                  0x80     	/* FIFO Data Error */


#endif /* __FARADAY_PLATFORM_INDEPENDENT_SERIAL_HEADER__ */
