/*   Copyright (C) 2004 Microtronix Datacom Ltd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                */

#ifndef _LINUX_I2C_ALGO_fia320_H
#define _LINUX_I2C_ALGO_fia320_H

#include "i2c-slave.h"

struct i2c_fia_interface_configuration {
    int base;
    int irq;
    int scl;
    int clock;
    uint8_t slave_address;
    char *name;
};

struct iic_fia320_hw {
	int base;
	int irq;
	int initialized;
	volatile int arbit_lost_xfer_error;
	volatile int lost_arbitration;
	volatile int transfer_done;
	volatile int handle_stop;
	volatile unsigned char master_read_byte;
	/* clock and speed */
	int clock;	/* in KHZ */
	int scl;	/* in KHZ */
	int isr;
	int idx;
	struct i2c_adapter* adap;	
	wait_queue_head_t wait;
	int pending;
};

#define FIA_SLAVE_BUF_SIZE 512

struct i2c_algo_fia320_slave_data {
	/* slave lock object */
	spinlock_t      slave_lock;
	
	/* slave write buffer */
	unsigned char * slave_write_ptr;
	unsigned int    slave_write_count;
	unsigned char   slave_write_buffer[FIA_SLAVE_BUF_SIZE];
	
	/* slave read buffer */
	unsigned char * slave_read_ptr;
	unsigned int    slave_read_count;
	unsigned char   slave_read_buffer[FIA_SLAVE_BUF_SIZE];
	
	/* status flags */
	int block_next_slave_operation;
	int slave_write_in_progress;
	int slave_read_in_progress;
	int ignore_slave_write_byte;
};

struct i2c_algo_fia320_data {
	struct iic_fia320_hw *hw;
	struct i2c_adapter *i2c_adap;
	struct i2c_algo_fia320_slave_data *slave_data;
	struct i2c_slave_adapter *slave_adapter;
	struct i2c_fia_interface_configuration *config;

	void (*setreg) (struct iic_fia320_hw *hw, int regno, int val);
	int  (*getreg) (struct iic_fia320_hw *hw, int regno);
	int  (*reset) (struct i2c_adapter *adap);
	/* local settings */
	int udelay;
	int mdelay;
	int timeout;
};

void i2c_fia320_isr(struct i2c_adapter *adap, int query_sts);
int i2c_fia320_slave_set_address(struct i2c_adapter* i2c_adap, unsigned int address);
int i2c_fia320_slave_restart_xfer(struct i2c_adapter* i2c_adap);

int i2c_fia320_add_bus(struct i2c_adapter *);
int i2c_fia320_del_bus(struct i2c_adapter *);

int i2c_fia320_clock_bus_free(struct i2c_adapter *);
void i2c_fia320_send_stop(struct i2c_adapter *);

/******************************************************************************
 * debugging into a buffer                                                    *
 ******************************************************************************/

#define DEBUG_TO_BUFFER	0

#if DEBUG_TO_BUFFER

void i2c_fia_print(const char *fmt, ...);

#endif /* DEBUG_TO_BUFFER */

#endif /* _LINUX_I2C_ALGO_fia320_H */
