/*   Copyright (C) 2004 Microtronix Datacom Ltd

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		*/

#ifndef I2C_FIA320_H
#define I2C_FIA320_H 1

/* registers */

#define REG_FA320_CR			0x00
#define REG_FA320_SR			0x04
#define REG_FA320_CDR			0x08
#define REG_FA320_DR			0x0c
#define REG_FA320_SAR			0x10
#define REG_FA320_TGSR			0x14
#define REG_FA320_BMR			0x18

/* control register CR */

#define FA320_CR_TEST                    0x20000 /* special test mode */
#define FA320_CR_SDA_LOW                 0x10000 /* force SDA to low */
#define FA320_CR_SCL_LOW                 0x8000  /* force SCL to low */
#define FA320_CR_STARTIEN                0x4000  
#define FA320_CR_ALIEN                   0x2000  /* Arbitration lose */
#define FA320_CR_SAMIEN                  0x1000  /* slave address match */
#define FA320_CR_STOPIEN                 0x800   /* stop condition */
#define FA320_CR_BERRIEN                 0x400   /* non ACK response */
#define FA320_CR_DRIEN                   0x200   /* data receive */
#define FA320_CR_DTIEN                   0x100   /* data transmit */
#define FA320_CR_TBEN                    0x80    /* transfer byte enable */
#define FA320_CR_ACKNAK                  0x40    /* ack sent */
#define FA320_CR_STOP                    0x20    /* stop */
#define FA320_CR_START                   0x10    /* start */
#define FA320_CR_GCEN                    0x8     /* general call */
#define FA320_CR_SCLEN                   0x4     /* enable clock */
#define FA320_CR_I2CEN                   0x2     /* enable I2C */
#define FA320_CR_I2CRST                  0x1     /* reset I2C */
#define FA320_CR_ENABLE                  (FA320_CR_ALIEN|FA320_CR_SAMIEN|FA320_CR_STOPIEN|FA320_CR_BERRIEN|FA320_CR_DRIEN|FA320_CR_DTIEN|FA320_CR_I2CEN)



/* I2C Status Register */

#define FA320_SR_START                 0x800
#define FA320_SR_AL                   0x400
#define FA320_SR_GC                   0x200
#define FA320_SR_SAM                  0x100
#define FA320_SR_STOP                 0x80
#define FA320_SR_BERR                 0x40
#define FA320_SR_DR                      0x20
#define FA320_SR_DT                      0x10
#define FA320_SR_BB                      0x8
#define FA320_SR_I2CB                    0x4
#define FA320_SR_ACK                     0x2
#define FA320_SR_RW                      0x1


/* I2C clock divided register */

#define FA320_CDR_CLKCOUNT                0x3ff

/* I2C slave address register */

#define FA320_SAR_EN10                    0x80000000  /* 10-bit address slave mode */
#define FA320_SAR_SARMSB                  0x380       /* mask for SAR msb when EN10=1 */
#define FA320_SAR_SARLSB                  0x7f            /* mask for SAR lsb */

/* Bus Monitor Register */

#define FA320_BMR_SCL                     0x2
#define FA320_BMR_SDA                     0x1


#endif /* I2C_FIA320_H */
