// Header file for BMP file format

#define RED	2
#define GREEN	1
#define BLUE	0

// .BMP file headers
#define	BMFHDRSIZE	sizeof(struct bmf_hdr)
struct bmf_hdr {
    unsigned char bfType[2];
    unsigned char bfSize[4];
    unsigned char bfReserved[4];
    unsigned char bfOffBits[4];
} defBmfHdr = {
    {'B', 'M'},			// file marker
    {0, 0, 0, 0},		// file size = 0?
    {0, 0, 0, 0}, 
    {54, 0, 0, 0}		// offset to beginning of bitmap data
};

#define	BMIHDRSIZE	sizeof(struct bmi_hdr)
struct bmi_hdr {
    unsigned char biSize[4];
    unsigned char biWidth[4];
    unsigned char biHeight[4];
    unsigned char biPlanes[2];
    unsigned char biBitCount[2];
    long biCompression;
    unsigned char biSizeImage[4];
    long biXPelsPerMeter;
    long biYPelsPerMeter;
    long biClrUsed;
    long biClrImportant;
} defBmiHdr = {
    {40, 0, 0, 0},		// size of this structure (40 bytes)
    {0, 0, 0, 0},		// Width of image
    {0, 0, 0, 0},		// Height of image
    {1, 0}, 
    {24, 0},			// 24 bitplanes
    0,
    {0, 0, 0, 0},		// image size, to be filled in later
    0, 0, 0, 0
};
