#include <stdio.h>
#include <pp/base.h>
#include <pp/powerswitch.h>
#include <liberic_um.h>
#include <liberic_webs.h>
#include <liberic_net.h>
#include <liberic_cron.h>


int main() {
    int		ret;
    char	cmd;

    printf("Initialize Base Library...\n");
    if (pp_base_init("eric", LOG_NOT_SILENT) != 0) {
	pp_log("Initializing base-library failed.\n");
	return -1;
    }

    /* used to read config vars from !global */
    printf("Initialize UM Library...\n");
    if (eric_um_base_init(0) != 0) {
	pp_log("Initializing um-library failed.\n");
	return -1;
    }

    printf("Initialize Power Switch Library...\n\n");
    if (pp_power_switch_init() != 0) {
	pp_log("Initializing power switch-library failed.\n");
	return -1;
    }

    printf("Open Power Switch Port...\n");
    if ( (ret = pp_power_open_login(PP_POWER_PORT_ID_INTERNAL)) ) {
	pp_log("Open Power Port failed: %d\n", ret);
    }

    do
	{
	    printf("\nPress l=ATX Long Press s=ATX Short Press r=Reset x=Exit : ");
	    cmd = getchar();
	    
	    switch (cmd)
		{
		  case 'l': ret = pp_power_switch(0, 0, 1, 0, PP_POWER_PORT_ID_INTERNAL); break;
		  case 's': ret = pp_power_switch(0, 0, 0, 0, PP_POWER_PORT_ID_INTERNAL); break;
		  case 'r': ret = pp_power_reset(0, 0, PP_POWER_PORT_ID_INTERNAL); break;
		  case 'x': goto final;
		  default: break;
		}
	    if ( ret ) {
		pp_log("Power switch failed: %d\n", ret);
	    } else {
		printf("Power switch performed\n");
	    }

	    getchar();
	} while ( 1 );

 final:
    printf("\nClosing Power Switch Port... \n");
    if ( (ret = pp_power_logout_close(PP_POWER_PORT_ID_INTERNAL)) ) {
	pp_log("Closing Power Port failed: %d\n", ret);
    }
    printf("Cleanup...\n");
    pp_power_switch_cleanup();
    eric_um_cleanup();
    pp_base_cleanup();

    return 0;
}		
