#include <stdio.h>
#include <pp/base.h>
#include <pp/sense.h>

int main() {
    float raw_value;
    char buf[32];

    printf("Initialize Base Library...\n");
    if (pp_base_init("eric", LOG_NOT_SILENT) != 0) {
	pp_log("Initializing base-library failed.\n");
	return -1;
    }

    printf("\nRead PCI Voltage: +12V\n");
    if ( !pp_sense_read_adc_value_str(buf, sizeof(buf), PCI_VOLTAGE_12V) ) {
	printf("%s V\n", buf);
    }

    printf("\nRead PCI Voltage: +5V\n");    
    if ( !pp_sense_read_adc_value_raw(&raw_value, PCI_VOLTAGE_5V) ) {
	printf("%.2f V\n", raw_value);
    }

    printf("\nRead PCI Voltage: VIO\n");    
    if ( !pp_sense_read_adc_value_str(buf, sizeof(buf), PCI_VOLTAGE_VIO) ) {
	printf("%s V\n", buf);
    }

    printf("\nRead PCI Voltage: +3.3V(PCI)\n");    
    if ( !pp_sense_read_adc_value_raw(&raw_value, PCI_VOLTAGE_3V_PCI) ) {
	printf("%.2f V\n", raw_value);
    }
	
    printf("\nRead PCI Voltage: +3.3V(AUX)\n");        
    if ( !pp_sense_read_adc_value_str(buf, sizeof(buf), PCI_VOLTAGE_3V_AUX) ) {
	printf("%s V\n", buf);
    }
	
    printf("\nRead PCI Voltage: -12V\n");    
    if ( !pp_sense_read_adc_value_raw(&raw_value, PCI_VOLTAGE_12V_NEG) ) {
	printf("%.2f V\n", raw_value);
    }
    
    return 0;
}		
