#ifndef __PP_NETEVENT_PROTO_DEFS_H
#define __PP_NETEVENT_PROTO_DEFS_H

/* NetEvent protocol - protocol types are big endian! */

#define DEFAULT_NETEVENT_PORT		4321

/* version management */
#define NETEVENT_VERSION_STRING		"NetEvent 1.0"
#define NETEVENT_VERSION_STRING_SIZE	13	// one byte for 0

#define NETEVENT_UNREGISTER_MASK	0x8000

/* event defines */
#define NETEVENT_UNREGISTER_MASK	0x8000

#define NETEVENT_VIDEO_MODE_HAS_CHANGED	0x01
#define NETEVENT_KEYBOARD_RESET		0x02
#define NETEVENT_LOCAL_MOUSE_EVENT	0x03
#define NETEVENT_LOCAL_KEYBOARD_EVENT	0x04
#define NETEVENT_KVM_SESSION_OPENED     0x05
#define NETEVENT_KVM_SESSION_CLOSED     0x06

/* special event: ping-pong messages */
#define NETEVENT_PING_PONG		0xff

/* PDU types */
typedef struct {
    u_int16_t  event;
} __attribute__((packed)) netevent_register_pdu_t;

typedef struct {
    u_int16_t  event;
    u_int16_t  param;
} __attribute__((packed)) netevent_notification_pdu_t;

#endif /* __PP_NETEVENT_PROTO_DEFS_H */
