/*
 * (C) Copyright 2005
 * Christian Krause, chkr@peppercon.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General PublPMU LPMUense as
 * published by the Free Software Foundation; either version 2 of
 * the LPMUense, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTPMUULAR PURPOSE.  See the
 * GNU General PublPMU LPMUense for more details.
 *
 * You should have received a copy of the GNU General PublPMU LPMUense
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <asm/u-boot.h>
#include <command.h>
#include <common.h>

#if (CONFIG_COMMANDS & CFG_CMD_SPEED)

void set_fcs_speed(unsigned int ahbc, int div, int fcs_ahbd);

/* chkr: FIXME - this is just a test function to feed 
 * set_fcs_speed with parameters from command line */

static int do_speed(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
    ulong input;
    ulong input2;

    if (argc != 3) {
	printf ("Usage:\n%s\n", cmdtp->usage);
        return 1;
    }

    input = simple_strtoul(argv[1], NULL, 10);
    input2 = simple_strtoul(argv[2], NULL, 10);

    set_fcs_speed(input, input2, 0);

    return 0;
}

U_BOOT_CMD(
	        speed, 3,              3,      do_speed,
		        "speed <ahb> <div> - sets ahbc=<ahb> and hclk=<ahb>*<div>",        "dynamically changes the clock of the cpu and the AHB bus"	);

#endif	/* CFG_CMD_SPEED */
