/*
 * unconditional printf
 *
 * when CONFIG_PEPPERCON is defined serial output will only do
 * in case of serial_debug is set. this function will overwrite
 * this behaviour and uncondtionally print text to console
 *
 * (c) Peppercon AG, 2006, tbr@raritan.com
 */

#include <common.h>
#include <stdarg.h>
#include <console.h>
#include <kira/console.h>

/* uc = unconditional */
void ucprintf (const char *fmt, ...) {
	va_list args;
	int is_sd;
	DECLARE_GLOBAL_DATA_PTR;

	is_sd = gd->pp.serial_debug;
	gd->pp.serial_debug = 1;
	
	va_start (args, fmt);
	vprintf(fmt, args);
	va_end (args);

	gd->pp.serial_debug = is_sd;
}

