/******************************************************************************
 *
 * Hardware configuration of AMD KIM-based board
 *
 * Hardware-ID: 0x11
 *
 */  

#ifndef _HW_11_H
#define _HW_11_H

/* ----------------------------------------------------------------------------
 * Miscellaneous Hardware Configuration
 */

#define PP_HWID_11_CPU_TYPE		PP_CPU_405EP	/* The CPU type */
#define PP_HWID_11_FLASH_SIZE		(8*1024*1024)	/* Flash size in bytes */
#define PP_HWID_11_SDRAM_ROWS		4096		/* SDRAM row count */
#define PP_HWID_11_SDRAM_B0CR		0x00062001	/* 32MB @ 0x0 12x9x4 */
#define PP_HWID_11_SDRAM_RTR		0x0618		/* 100 MHz; 64ms; 4k refresh */
#define PP_HWID_11_SDRAM_TR		0x0086400D	/* 100 MHz; CASL=2, PTA=2, CTP=3, LDF=2, RFTA=7, RCD=2 */
#define PP_HWID_11_SYS_CLK_FREQ		33333333	/* external frequency to PLL */
#define PP_HWID_11_PHY_LED_CFG_VALUE	0x0472		/* LXT972A; register 0x14 */
#define PP_HWID_11_BIGPHYSAREA_PAGES	1026		/* # of reserved pages for linux */
#define PP_HWID_11_CONSOLE              PP_SERIAL_0

#define PP_HWID_11_DESCRIPTION		"AMD KIM 1.2 / AMD MB"

#define PP_HWID_11_CONFIG_BOOTDELAY     1

/* ----------------------------------------------------------------------------
 * The PLL configuration (see PPC405EP manual section 7.2, 7.5.3 and 7.5.4)
 */

#define PP_HWID_11_DYNAMIC_PLL	   0

/* ------------- 33 MHz SysClk Settings --------------- */
/* Slow (66 MHz CPU-Clk) */
#define PP_HWID_11_PLLMR0_SLOW (PLL_CPUDIV_2		\
				   | PLL_PLBDIV_1	\
				   | PLL_OPBDIV_2	\
				   | PLL_EXTBUSDIV_2	\
				   | PLL_MALDIV_1	\
				   | PLL_PCIDIV_4)

#define PP_HWID_11_PLLMR1_SLOW (PLL_FBKDIV_6		\
				   | PLL_FWDDIVA_4	\
				   | PLL_FWDDIVB_4	\
				   | PLL_TUNE_15_M_40	\
				   | PLL_TUNE_VCO_LOW)

/* Fast (200 MHz CPU-Clk, 33 MHz bus) */
#define PP_HWID_11_PLLMR0_FAST (PLL_CPUDIV_1		\
				   | PLL_PLBDIV_2	\
				   | PLL_OPBDIV_2	\
				   | PLL_EXTBUSDIV_3	\
				   | PLL_MALDIV_1	\
				   | PLL_PCIDIV_3)

#define PP_HWID_11_PLLMR1_FAST (PLL_FBKDIV_6		\
				   | PLL_FWDDIVA_4	\
				   | PLL_FWDDIVB_4	\
				   | PLL_TUNE_15_M_40	\
				   | PLL_TUNE_VCO_LOW)
					
#define PP_HWID_11_PLLMR0_DEFAULT	PP_HWID_11_PLLMR0_FAST
#define PP_HWID_11_PLLMR1_DEFAULT	PP_HWID_11_PLLMR1_FAST

/* ----------------------------------------------------------------------------
 * GPIO configuration
 */

/* GPIO 0: Unused */
#define PP_HWID_11_GPIO_00_IS_OUTPUT		0
#define PP_HWID_11_GPIO_00_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_00_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_00_IS_GPIO		0

/* GPIO 1: ATMEL_MISO */
#define PP_HWID_11_GPIO_01_IS_OUTPUT		0
#define PP_HWID_11_GPIO_01_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_01_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_01_IS_GPIO		1

/* GPIO 2: ATMEL MOSI / FPGA_TDI */
#define PP_HWID_11_GPIO_02_IS_OUTPUT		1
#define PP_HWID_11_GPIO_02_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_02_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_02_IS_GPIO		1

/* GPIO 3: ATMEL_RST */
#define PP_HWID_11_GPIO_03_IS_OUTPUT		1
#define PP_HWID_11_GPIO_03_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_03_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_03_IS_GPIO		1

/* GPIO 4: ATMEL_SCK / FPGA_TCK */
#define PP_HWID_11_GPIO_04_IS_OUTPUT		1
#define PP_HWID_11_GPIO_04_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_04_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_04_IS_GPIO		1

/* GPIO 5: Default Jumper */
#define PP_HWID_11_GPIO_05_IS_OUTPUT		0
#define PP_HWID_11_GPIO_05_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_05_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_05_IS_GPIO		1

/* GPIO 6: Host RST */
#define PP_HWID_11_GPIO_06_IS_OUTPUT		1
#define PP_HWID_11_GPIO_06_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_06_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_06_IS_GPIO		1

/* GPIO 7: Host ATX */
#define PP_HWID_11_GPIO_07_IS_OUTPUT		1
#define PP_HWID_11_GPIO_07_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_07_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_07_IS_GPIO		1

/* GPIO 8: FPGA_TMS */
#define PP_HWID_11_GPIO_08_IS_OUTPUT		1
#define PP_HWID_11_GPIO_08_IS_OPEN_DRAIN	1
#define PP_HWID_11_GPIO_08_OUTPUT_VALUE		1
#define PP_HWID_11_GPIO_08_IS_GPIO		1

/* GPIO 9: LED2 / Active low */
#define PP_HWID_11_GPIO_09_IS_OUTPUT		1
#define PP_HWID_11_GPIO_09_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_09_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_09_IS_GPIO		1

/* GPIO 10: Unused */
#define PP_HWID_11_GPIO_10_IS_OUTPUT		0
#define PP_HWID_11_GPIO_10_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_10_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_10_IS_GPIO		0

/* GPIO 11: Unused */
#define PP_HWID_11_GPIO_11_IS_OUTPUT		0
#define PP_HWID_11_GPIO_11_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_11_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_11_IS_GPIO		0

/* GPIO 12: Unused */
#define PP_HWID_11_GPIO_12_IS_OUTPUT		0
#define PP_HWID_11_GPIO_12_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_12_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_12_IS_GPIO		0

/* GPIO 13: Unused */
#define PP_HWID_11_GPIO_13_IS_OUTPUT		0
#define PP_HWID_11_GPIO_13_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_13_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_13_IS_GPIO		0

/* GPIO 14: Unused */
#define PP_HWID_11_GPIO_14_IS_OUTPUT		0
#define PP_HWID_11_GPIO_14_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_14_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_14_IS_GPIO		0

/* GPIO 15: Unused */
#define PP_HWID_11_GPIO_15_IS_OUTPUT		0
#define PP_HWID_11_GPIO_15_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_15_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_15_IS_GPIO		0

/* GPIO 16: Unused */
#define PP_HWID_11_GPIO_16_IS_OUTPUT		0
#define PP_HWID_11_GPIO_16_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_16_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_16_IS_GPIO		0

/* GPIO 17: Unused */
#define PP_HWID_11_GPIO_17_IS_OUTPUT		0
#define PP_HWID_11_GPIO_17_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_17_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_17_IS_GPIO		0

/* GPIO 18: Unused */
#define PP_HWID_11_GPIO_18_IS_OUTPUT		0
#define PP_HWID_11_GPIO_18_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_18_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_18_IS_GPIO		0

/* GPIO 19: Unused */
#define PP_HWID_11_GPIO_19_IS_OUTPUT		0
#define PP_HWID_11_GPIO_19_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_19_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_19_IS_GPIO		0

/* GPIO 20: FPGA_TDO */
#define PP_HWID_11_GPIO_20_IS_OUTPUT		0
#define PP_HWID_11_GPIO_20_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_20_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_20_IS_GPIO		1

/* GPIO 21: Unused */
#define PP_HWID_11_GPIO_21_IS_OUTPUT		0
#define PP_HWID_11_GPIO_21_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_21_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_21_IS_GPIO		0

/* GPIO 22: Unused */
#define PP_HWID_11_GPIO_22_IS_OUTPUT		0
#define PP_HWID_11_GPIO_22_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_22_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_22_IS_GPIO		0

/* GPIO 23: Unused */
#define PP_HWID_11_GPIO_23_IS_OUTPUT		0
#define PP_HWID_11_GPIO_23_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_23_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_23_IS_GPIO		0

/* GPIO 24: Unused */
#define PP_HWID_11_GPIO_24_IS_OUTPUT		0
#define PP_HWID_11_GPIO_24_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_24_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_24_IS_GPIO		0

/* GPIO 25: Unused */
#define PP_HWID_11_GPIO_25_IS_OUTPUT		0
#define PP_HWID_11_GPIO_25_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_25_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_25_IS_GPIO		0

/* GPIO 26: Unused */
#define PP_HWID_11_GPIO_26_IS_OUTPUT		0
#define PP_HWID_11_GPIO_26_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_26_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_26_IS_GPIO		0

/* GPIO 27: Unused */
#define PP_HWID_11_GPIO_27_IS_OUTPUT		0
#define PP_HWID_11_GPIO_27_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_27_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_27_IS_GPIO		0

/* GPIO 28: Unused */
#define PP_HWID_11_GPIO_28_IS_OUTPUT		0
#define PP_HWID_11_GPIO_28_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_28_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_28_IS_GPIO		0

/* GPIO 29: Unused */
#define PP_HWID_11_GPIO_29_IS_OUTPUT		0
#define PP_HWID_11_GPIO_29_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_29_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_29_IS_GPIO		0

/* GPIO 30: Unused */
#define PP_HWID_11_GPIO_30_IS_OUTPUT		0
#define PP_HWID_11_GPIO_30_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_30_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_30_IS_GPIO		0

/* GPIO 31: Unused */
#define PP_HWID_11_GPIO_31_IS_OUTPUT		0
#define PP_HWID_11_GPIO_31_IS_OPEN_DRAIN	0
#define PP_HWID_11_GPIO_31_OUTPUT_VALUE		0
#define PP_HWID_11_GPIO_31_IS_GPIO		0

/* ----------------------------------------------------------------------------
 * External IRQ configuration
 */

/* USB_IRQ */
#define PP_HWID_11_EXT_IRQ_00_HAS_POS_POLARITY	0
#define PP_HWID_11_EXT_IRQ_00_IS_EDGE_TRIGGERED	0

/* PHY_IRQ */
#define PP_HWID_11_EXT_IRQ_01_HAS_POS_POLARITY	0
#define PP_HWID_11_EXT_IRQ_01_IS_EDGE_TRIGGERED	0

/* Unused */
#define PP_HWID_11_EXT_IRQ_02_HAS_POS_POLARITY	0
#define PP_HWID_11_EXT_IRQ_02_IS_EDGE_TRIGGERED	0

/* Used as GPIO */
#define PP_HWID_11_EXT_IRQ_03_HAS_POS_POLARITY	0
#define PP_HWID_11_EXT_IRQ_03_IS_EDGE_TRIGGERED	0

/* Unused */
#define PP_HWID_11_EXT_IRQ_04_HAS_POS_POLARITY	0
#define PP_HWID_11_EXT_IRQ_04_IS_EDGE_TRIGGERED	0

/* VSC_IRQ */
#define PP_HWID_11_EXT_IRQ_05_HAS_POS_POLARITY	0
#define PP_HWID_11_EXT_IRQ_05_IS_EDGE_TRIGGERED	0

/* Unused */
#define PP_HWID_11_EXT_IRQ_06_HAS_POS_POLARITY	0
#define PP_HWID_11_EXT_IRQ_06_IS_EDGE_TRIGGERED	0

/* ----------------------------------------------------------------------------
 * Chip Select configuration
 */

/* ---- Bank 0: Flash ---- */

#define PP_HWID_11_CS_00_AP_BME		0x1	/* Burst mode enabled (1 bit) */
#define PP_HWID_11_CS_00_AP_FWT		0x6	/* First Wait for Burst mode (5 bit) */
#define PP_HWID_11_CS_00_AP_BWT		0x6	/* Non-first Wait for Burst mode (3 bit) */
#define PP_HWID_11_CS_00_AP_TWT		0x0	/* Transfer Wait for non Burst mode (8 bit) */
#define PP_HWID_11_CS_00_AP_CSN		0x0	/* /PerCS on after address delay (2 bit) */
#define PP_HWID_11_CS_00_AP_OEN		0x1	/* /PerOE on after /PerCS delay (2 bit) */
#define PP_HWID_11_CS_00_AP_WBN		0x1	/* /PerWBE0:3 on after /PerCS if BEM = 0 (2 bit) */
#define PP_HWID_11_CS_00_AP_WBF		0x1	/* /PerWBE0:3 off before /PerCS off if BEM = 0 (2 bit) */
#define PP_HWID_11_CS_00_AP_TH		0x2	/* Transfer hold after end of transfer (3 bit) */
#define PP_HWID_11_CS_00_AP_RE		0x0	/* Ready Enable (1 bit) */
#define PP_HWID_11_CS_00_AP_SOR		0x1	/* Sample on Ready (1 bit) */
#define PP_HWID_11_CS_00_AP_BEM		0x0	/* Byte Enable Mode (1 bit) */
#define PP_HWID_11_CS_00_AP_PEN		0x0	/* Partity Enable (1 bit) */

/* Base Address - must be multiple of BS */
#define PP_HWID_11_CS_00_CR_BAS		0xFF800000
/* Bank Size (3 bit); 0b000 = 1MB, 0b001 = 2MB, ..., 0b111 = 128MB */
#define PP_HWID_11_CS_00_CR_BS		0x3
/* Bank Usage (2 bit); 0x0 = disabled; 0x1 = r/o; 0x2 = w/o; 0x3 = r/w */
#define PP_HWID_11_CS_00_CR_BU		0x3
/* BusWidth (2 bit); 0x0 = 8bit; 0x1 = 16bit; 0x2 = 32bit; 0x3 = reserved */
#define PP_HWID_11_CS_00_CR_BW		0x1

/* ---- Bank 1: USB ---- */

/*
 * NOTE: The USB chip has PerRW connected to its WR_N pin. This is wrong.
 *       As a workaround we set the hold time to 0.
 */

#define PP_HWID_11_CS_01_AP_BME		0x0	/* Burst mode enabled (1 bit) */
#define PP_HWID_11_CS_01_AP_FWT		0x0	/* First Wait for Burst mode (5 bit) */
#define PP_HWID_11_CS_01_AP_BWT		0x0	/* Non-first Wait for Burst mode (3 bit) */
#define PP_HWID_11_CS_01_AP_TWT		0x5	/* Transfer Wait for non Burst mode (8 bit) */
#define PP_HWID_11_CS_01_AP_CSN		0x0	/* /PerCS on after address delay (2 bit) */
#define PP_HWID_11_CS_01_AP_OEN		0x1	/* /PerOE on after /PerCS delay (2 bit) */
#define PP_HWID_11_CS_01_AP_WBN		0x1	/* /PerWBE0:3 on after /PerCS if BEM = 0 (2 bit) */
#define PP_HWID_11_CS_01_AP_WBF		0x1	/* /PerWBE0:3 off before /PerCS off if BEM = 0 (2 bit) */
#define PP_HWID_11_CS_01_AP_TH		0x0	/* Transfer hold after end of transfer (3 bit) */
#define PP_HWID_11_CS_01_AP_RE		0x0	/* Ready Enable (1 bit) */
#define PP_HWID_11_CS_01_AP_SOR		0x1	/* Sample on Ready (1 bit) */
#define PP_HWID_11_CS_01_AP_BEM		0x0	/* Byte Enable Mode (1 bit) */
#define PP_HWID_11_CS_01_AP_PEN		0x0	/* Partity Enable (1 bit) */

/* Base Address - must be multiple of BS */
#define PP_HWID_11_CS_01_CR_BAS		0xF0000000
/* Bank Size (3 bit); 0b000 = 1MB, 0b001 = 2MB, ..., 0b111 = 128MB */
#define PP_HWID_11_CS_01_CR_BS		0x0
/* Bank Usage (2 bit); 0x0 = disabled; 0x1 = r/o; 0x2 = w/o; 0x3 = r/w */
#define PP_HWID_11_CS_01_CR_BU		0x3
/* BusWidth (2 bit); 0x0 = 8bit; 0x1 = 16bit; 0x2 = 32bit; 0x3 = reserved */
#define PP_HWID_11_CS_01_CR_BW		0x1

/* ---- Bank 2: Hardware-ID ---- */

#define PP_HWID_11_CS_02_AP_BME		0x0	/* Burst mode enabled (1 bit) */
#define PP_HWID_11_CS_02_AP_FWT		0x0	/* First Wait for Burst mode (5 bit) */
#define PP_HWID_11_CS_02_AP_BWT		0x0	/* Non-first Wait for Burst mode (3 bit) */
#define PP_HWID_11_CS_02_AP_TWT		0x8	/* Transfer Wait for non Burst mode (8 bit) */
#define PP_HWID_11_CS_02_AP_CSN		0x0	/* /PerCS on after address delay (2 bit) */
#define PP_HWID_11_CS_02_AP_OEN		0x1	/* /PerOE on after /PerCS delay (2 bit) */
#define PP_HWID_11_CS_02_AP_WBN		0x1	/* /PerWBE0:3 on after /PerCS if BEM = 0 (2 bit) */
#define PP_HWID_11_CS_02_AP_WBF		0x1	/* /PerWBE0:3 off before /PerCS off if BEM = 0 (2 bit) */
#define PP_HWID_11_CS_02_AP_TH		0x2	/* Transfer hold after end of transfer (3 bit) */
#define PP_HWID_11_CS_02_AP_RE		0x0	/* Ready Enable (1 bit) */
#define PP_HWID_11_CS_02_AP_SOR		0x1	/* Sample on Ready (1 bit) */
#define PP_HWID_11_CS_02_AP_BEM		0x0	/* Byte Enable Mode (1 bit) */
#define PP_HWID_11_CS_02_AP_PEN		0x0	/* Partity Enable (1 bit) */

/* Base Address - must be multiple of BS */
#define PP_HWID_11_CS_02_CR_BAS		0xF0600000
/* Bank Size (3 bit); 0b000 = 1MB, 0b001 = 2MB, ..., 0b111 = 128MB */
#define PP_HWID_11_CS_02_CR_BS		0x0
/* Bank Usage (2 bit); 0x0 = disabled; 0x1 = r/o; 0x2 = w/o; 0x3 = r/w */
#define PP_HWID_11_CS_02_CR_BU		0x3
/* BusWidth (2 bit); 0x0 = 8bit; 0x1 = 16bit; 0x2 = 32bit; 0x3 = reserved */
#define PP_HWID_11_CS_02_CR_BW		0x0


/* ---- Bank 3: Unused ---- */

#define PP_HWID_11_CS_03_AP_BME		0x0	/* Burst mode enabled (1 bit) */
#define PP_HWID_11_CS_03_AP_FWT		0x0	/* First Wait for Burst mode (5 bit) */
#define PP_HWID_11_CS_03_AP_BWT		0x0	/* Non-first Wait for Burst mode (3 bit) */
#define PP_HWID_11_CS_03_AP_TWT		0x0	/* Transfer Wait for non Burst mode (8 bit) */
#define PP_HWID_11_CS_03_AP_CSN		0x0	/* /PerCS on after address delay (2 bit) */
#define PP_HWID_11_CS_03_AP_OEN		0x0	/* /PerOE on after /PerCS delay (2 bit) */
#define PP_HWID_11_CS_03_AP_WBN		0x0	/* /PerWBE0:3 on after /PerCS if BEM = 0 (2 bit) */
#define PP_HWID_11_CS_03_AP_WBF		0x0	/* /PerWBE0:3 off before /PerCS off if BEM = 0 (2 bit) */
#define PP_HWID_11_CS_03_AP_TH		0x0	/* Transfer hold after end of transfer (3 bit) */
#define PP_HWID_11_CS_03_AP_RE		0x0	/* Ready Enable (1 bit) */
#define PP_HWID_11_CS_03_AP_SOR		0x0	/* Sample on Ready (1 bit) */
#define PP_HWID_11_CS_03_AP_BEM		0x0	/* Byte Enable Mode (1 bit) */
#define PP_HWID_11_CS_03_AP_PEN		0x0	/* Partity Enable (1 bit) */

/* Base Address - must be multiple of BS */
#define PP_HWID_11_CS_03_CR_BAS		0x00000000
/* Bank Size (3 bit); 0b000 = 1MB, 0b001 = 2MB, ..., 0b111 = 128MB */
#define PP_HWID_11_CS_03_CR_BS		0x0
/* Bank Usage (2 bit); 0x0 = disabled; 0x1 = r/o; 0x2 = w/o; 0x3 = r/w */
#define PP_HWID_11_CS_03_CR_BU		0x0
/* BusWidth (2 bit); 0x0 = 8bit; 0x1 = 16bit; 0x2 = 32bit; 0x3 = reserved */
#define PP_HWID_11_CS_03_CR_BW		0x0

/* ---- Bank 4: VSC ---- */

#define PP_HWID_11_CS_04_AP_BME		0x1	/* Burst mode enabled (1 bit) */
#define PP_HWID_11_CS_04_AP_FWT		0x0	/* First Wait for Burst mode (5 bit) */
#define PP_HWID_11_CS_04_AP_BWT		0x0	/* Non-first Wait for Burst mode (3 bit) */
#define PP_HWID_11_CS_04_AP_TWT		0x0	/* Transfer Wait for non Burst mode (8 bit) */
#define PP_HWID_11_CS_04_AP_CSN		0x0	/* /PerCS on after address delay (2 bit) */
#define PP_HWID_11_CS_04_AP_OEN		0x0	/* /PerOE on after /PerCS delay (2 bit) */
#define PP_HWID_11_CS_04_AP_WBN		0x0	/* /PerWBE0:3 on after /PerCS if BEM = 0 (2 bit) */
#define PP_HWID_11_CS_04_AP_WBF		0x0	/* /PerWBE0:3 off before /PerCS off if BEM = 0 (2 bit) */
#define PP_HWID_11_CS_04_AP_TH		0x0	/* Transfer hold after end of transfer (3 bit) */
#define PP_HWID_11_CS_04_AP_RE		0x1	/* Ready Enable (1 bit) */
#define PP_HWID_11_CS_04_AP_SOR		0x1	/* Sample on Ready (1 bit) */
#define PP_HWID_11_CS_04_AP_BEM		0x0	/* Byte Enable Mode (1 bit) */
#define PP_HWID_11_CS_04_AP_PEN		0x0	/* Partity Enable (1 bit) */

/* Base Address - must be multiple of BS */
#define PP_HWID_11_CS_04_CR_BAS		0xF1000000
/* Bank Size (3 bit); 0b000 = 1MB, 0b001 = 2MB, ..., 0b111 = 128MB */
#define PP_HWID_11_CS_04_CR_BS		0x3
/* Bank Usage (2 bit); 0x0 = disabled; 0x1 = r/o; 0x2 = w/o; 0x3 = r/w */
#define PP_HWID_11_CS_04_CR_BU		0x3
/* BusWidth (2 bit); 0x0 = 8bit; 0x1 = 16bit; 0x2 = 32bit; 0x3 = reserved */
#define PP_HWID_11_CS_04_CR_BW		0x1

/* ---- Bank 5: Unused ---- */

#define PP_HWID_11_CS_05_AP_BME		0x0	/* Burst mode enabled (1 bit) */
#define PP_HWID_11_CS_05_AP_FWT		0x0	/* First Wait for Burst mode (5 bit) */
#define PP_HWID_11_CS_05_AP_BWT		0x0	/* Non-first Wait for Burst mode (3 bit) */
#define PP_HWID_11_CS_05_AP_TWT		0x0	/* Transfer Wait for non Burst mode (8 bit) */
#define PP_HWID_11_CS_05_AP_CSN		0x0	/* /PerCS on after address delay (2 bit) */
#define PP_HWID_11_CS_05_AP_OEN		0x0	/* /PerOE on after /PerCS delay (2 bit) */
#define PP_HWID_11_CS_05_AP_WBN		0x0	/* /PerWBE0:3 on after /PerCS if BEM = 0 (2 bit) */
#define PP_HWID_11_CS_05_AP_WBF		0x0	/* /PerWBE0:3 off before /PerCS off if BEM = 0 (2 bit) */
#define PP_HWID_11_CS_05_AP_TH		0x0	/* Transfer hold after end of transfer (3 bit) */
#define PP_HWID_11_CS_05_AP_RE		0x0	/* Ready Enable (1 bit) */
#define PP_HWID_11_CS_05_AP_SOR		0x0	/* Sample on Ready (1 bit) */
#define PP_HWID_11_CS_05_AP_BEM		0x0	/* Byte Enable Mode (1 bit) */
#define PP_HWID_11_CS_05_AP_PEN		0x0	/* Partity Enable (1 bit) */

/* Base Address - must be multiple of BS */
#define PP_HWID_11_CS_05_CR_BAS		0x00000000
/* Bank Size (3 bit); 0b000 = 1MB, 0b001 = 2MB, ..., 0b111 = 128MB */
#define PP_HWID_11_CS_05_CR_BS		0x0
/* Bank Usage (2 bit); 0x0 = disabled; 0x1 = r/o; 0x2 = w/o; 0x3 = r/w */
#define PP_HWID_11_CS_05_CR_BU		0x0
/* BusWidth (2 bit); 0x0 = 8bit; 0x1 = 16bit; 0x2 = 32bit; 0x3 = reserved */
#define PP_HWID_11_CS_05_CR_BW		0x0

/* ---- Bank 6: unused ---- */

#define PP_HWID_11_CS_06_AP_BME		0x0	/* Burst mode enabled (1 bit) */
#define PP_HWID_11_CS_06_AP_FWT		0x0	/* First Wait for Burst mode (5 bit) */
#define PP_HWID_11_CS_06_AP_BWT		0x0	/* Non-first Wait for Burst mode (3 bit) */
#define PP_HWID_11_CS_06_AP_TWT		0x0	/* Transfer Wait for non Burst mode (8 bit) */
#define PP_HWID_11_CS_06_AP_CSN		0x0	/* /PerCS on after address delay (2 bit) */
#define PP_HWID_11_CS_06_AP_OEN		0x0	/* /PerOE on after /PerCS delay (2 bit) */
#define PP_HWID_11_CS_06_AP_WBN		0x0	/* /PerWBE0:3 on after /PerCS if BEM = 0 (2 bit) */
#define PP_HWID_11_CS_06_AP_WBF		0x0	/* /PerWBE0:3 off before /PerCS off if BEM = 0 (2 bit) */
#define PP_HWID_11_CS_06_AP_TH		0x0	/* Transfer hold after end of transfer (3 bit) */
#define PP_HWID_11_CS_06_AP_RE		0x0	/* Ready Enable (1 bit) */
#define PP_HWID_11_CS_06_AP_SOR		0x0	/* Sample on Ready (1 bit) */
#define PP_HWID_11_CS_06_AP_BEM		0x0	/* Byte Enable Mode (1 bit) */
#define PP_HWID_11_CS_06_AP_PEN		0x0	/* Partity Enable (1 bit) */

/* Base Address - must be multiple of BS */
#define PP_HWID_11_CS_06_CR_BAS		0x00000000
/* Bank Size (3 bit); 0b000 = 1MB, 0b001 = 2MB, ..., 0b111 = 128MB */
#define PP_HWID_11_CS_06_CR_BS		0x0
/* Bank Usage (2 bit); 0x0 = disabled; 0x1 = r/o; 0x2 = w/o; 0x3 = r/w */
#define PP_HWID_11_CS_06_CR_BU		0x0
/* BusWidth (2 bit); 0x0 = 8bit; 0x1 = 16bit; 0x2 = 32bit; 0x3 = reserved */
#define PP_HWID_11_CS_06_CR_BW		0x0

/* ---- Bank 7: Unused ---- */

#define PP_HWID_11_CS_07_AP_BME		0x0	/* Burst mode enabled (1 bit) */
#define PP_HWID_11_CS_07_AP_FWT		0x0	/* First Wait for Burst mode (5 bit) */
#define PP_HWID_11_CS_07_AP_BWT		0x0	/* Non-first Wait for Burst mode (3 bit) */
#define PP_HWID_11_CS_07_AP_TWT		0x0	/* Transfer Wait for non Burst mode (8 bit) */
#define PP_HWID_11_CS_07_AP_CSN		0x0	/* /PerCS on after address delay (2 bit) */
#define PP_HWID_11_CS_07_AP_OEN		0x0	/* /PerOE on after /PerCS delay (2 bit) */
#define PP_HWID_11_CS_07_AP_WBN		0x0	/* /PerWBE0:3 on after /PerCS if BEM = 0 (2 bit) */
#define PP_HWID_11_CS_07_AP_WBF		0x0	/* /PerWBE0:3 off before /PerCS off if BEM = 0 (2 bit) */
#define PP_HWID_11_CS_07_AP_TH		0x0	/* Transfer hold after end of transfer (3 bit) */
#define PP_HWID_11_CS_07_AP_RE		0x0	/* Ready Enable (1 bit) */
#define PP_HWID_11_CS_07_AP_SOR		0x0	/* Sample on Ready (1 bit) */
#define PP_HWID_11_CS_07_AP_BEM		0x0	/* Byte Enable Mode (1 bit) */
#define PP_HWID_11_CS_07_AP_PEN		0x0	/* Partity Enable (1 bit) */

/* Base Address - must be multiple of BS */
#define PP_HWID_11_CS_07_CR_BAS		0x00000000
/* Bank Size (3 bit); 0b000 = 1MB, 0b001 = 2MB, ..., 0b111 = 128MB */
#define PP_HWID_11_CS_07_CR_BS		0x0
/* Bank Usage (2 bit); 0x0 = disabled; 0x1 = r/o; 0x2 = w/o; 0x3 = r/w */
#define PP_HWID_11_CS_07_CR_BU		0x0
/* BusWidth (2 bit); 0x0 = 8bit; 0x1 = 16bit; 0x2 = 32bit; 0x3 = reserved */
#define PP_HWID_11_CS_07_CR_BW		0x0

/* ----------------------------------------------------------------------------
 * EBC configuration register
 */

#define PP_HWID_11_EBC_CFG_EBTC		0x1	/* ECB Three-State Control (1 bit) */
#define PP_HWID_11_EBC_CFG_PTD		0x0	/* Device-Paced Time-out Disable (1 bit) */
#define PP_HWID_11_EBC_CFG_RTC		0x3	/* Ready Timeout Count when PTD=0 (3 bit) */
#define PP_HWID_11_EBC_CFG_EMPL		0x0	/* External Master Priority Low (2 bit) */
#define PP_HWID_11_EBC_CFG_EMPH		0x0	/* External Master Priority High (2 bit) */
#define PP_HWID_11_EBC_CFG_CSTC		0x1	/* Chip Select Three-State Control (1 bit) */
#define PP_HWID_11_EBC_CFG_BPF		0x2	/* Burst Prefetch (2 bit) */
#define PP_HWID_11_EBC_CFG_EMS		0x0	/* External Master Size (2 bit) */
#define PP_HWID_11_EBC_CFG_PME		0x0	/* Power Management Enable (1 bit) */
#define PP_HWID_11_EBC_CFG_PMT		0x0	/* Power Management Timer (5 bit) */

#endif /* _HW_11_H */
