/*****************************************************************************
 *  Analog Devices Analog Flat Panel Interface Driver header file
 *
 *  FILE: ad9888.h
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _AD9888_H_
#define _AD9888_H_

/* Max AD9888 device */
#define AD9888_MAX_DEV                   4

/* Function return value definitions */
#define AD9888_SUCCESS                   0
#define AD9888_FAIL                     -1

/* driver state */
#define AD9888_UNINIT                    0
#define AD9888_INITED                    1

/* Register address */
#define AD9888_CHIP_REV                  0x00    /* RO */
#define AD9888_PLL_DIV_MSB               0x01    /* R/W */
#define AD9888_PLL_DIV_LSB               0x02    /* R/W */
#define AD9888_VCO                       0x03    /* R/W */
#define AD9888_PHASE_ADJUST              0x04    /* R/W */
#define AD9888_CLAMP_PLACEMENT           0x05    /* R/W */
#define AD9888_CLAMP_DURATION            0x06    /* R/W */
#define AD9888_HSYNC_OUTPUT_PULSEWIDTH   0x07    /* R/W */
#define AD9888_RED_GAIN                  0x08    /* R/W */
#define AD9888_GREEN_GAIN                0x09    /* R/W */
#define AD9888_BLUE_GAIN                 0x0A    /* R/W */
#define AD9888_RED_OFFSET                0x0B    /* R/W */
#define AD9888_GREEN_OFFSET              0x0C    /* R/W */
#define AD9888_BLUE_OFFSET               0x0D    /* R/W */
#define AD9888_SYNC_CONTROL1             0x0E    /* R/W */
#define AD9888_SYNC_CONTROL2             0x0F    /* R/W */
#define AD9888_SYNC_ON_GREEN             0x10    /* R/W */
#define AD9888_SYNC_SEPARATOR_THRESHOLD  0x11    /* R/W */
#define AD9888_PRE_COAST                 0x12    /* R/W */
#define AD9888_POST_COAST                0x13    /* R/W */
#define AD9888_SYNC_DETECT1              0x14    /* RO */
#define AD9888_SYNC_DETECT2              0x15    /* R/W */
#define AD9888_TEST_REG1                 0x16    /* R/W */
#define AD9888_TEST_REG2                 0x17    /* R/W */
#define AD9888_TEST_REG3                 0x18    /* RO */
#define AD9888_TEST_REG4                 0x19    /* RO */

/* Default register values */
#define AD9888_DEF_CLAMP_PLACEMENT       0x08
#define AD9888_DEF_CLAMP_DURATION        0x14
#define AD9888_DEF_GAIN                  0x80
#define AD9888_DEF_COAST                 0x00
#define AD9888_DEF_TEST_REG1             0xFF
#define AD9888_DEF_TEST_REG2             0x00

#define AD9888_NORMAL_TEST_REG1          0xFE

typedef struct {
    u8                  ba;          /* Base address              */
    u8                  state;       /* Device state              */
    u8                  imr;         /* Interrupt mask shadow     */
} ad9888_dev_t;

extern ad9888_dev_t addev[AD9888_MAX_DEV];

extern s32  ad9888_init( u32 num_devices );
extern s32  ad9888_install( u32 dev, u32 base_addr );
extern s32  ad9888_reset( u32 dev );
extern s32  ad9888_test( u32 dev );
extern u8   ad9888_read( u32 dev, u8 reg );
extern void ad9888_write( u32 dev, u8 reg, u8 val );
extern void ad9888_print( uchar reg, uchar val );

#endif /* _AD9888_H_ */
