/*****************************************************************************
 *  LED Utilities Menu
 *
 *  FILE: led_menu.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>

#if defined(CFG_RARITAN_UTIL_LED)

#include <led.h>
#include <led_menu.h>
#include <util.h>


static void print_led_menu( void )
{
    printf("\nLED Utility:");
    print_exit();
    printf("\n\t 1: Select LED");
    printf("\n\t 2: Turn On");
    printf("\n\t 3: Turn Off");
    printf("\n\t 4: Toggle");
    printf("\n\n");

    return;
}

int led_menu( void )
{
    char led_flag = 1;
    int result = 1; /* result is used for reverting back to U-boot cmds */
    unsigned long diag_opt;
    int opt_res;
    static int led_id = -1;

    led_init();

    while( led_id == -1 ) {
        led_select(&led_id);
    }

    while (led_flag) {
        print_led_menu();

        opt_res = menu_get_user_input(&diag_opt);
        if( opt_res > 0 ) {
            return 0;
        }
        else if( opt_res < 0 ) {
            continue;
        }

        switch( diag_opt ) {
            case LED_MENU_EXIT:
                led_flag = 0;
                break;

            case LED_MENU_SELECT:
                led_select(&led_id);
                break;

            case LED_MENU_TURN_ON:
                led_on(led_id);
                break;

            case LED_MENU_TURN_OFF:
                led_off(led_id);
                break;

            case LED_MENU_TOGGLE:
                led_toggle(led_id);
                break;

            default:
                print_invalid();
                break;
        }
    }

    led_cleanup();

    return result;
}

#endif /* (CFG_RARITAN_UTIL_LED) */
