/*****************************************************************************
 *  Philips PCF8574 Remote 8-bit I/O expander for I2C-bus interface functions
 *
 *  FILE: pcf8574.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>
#include <command.h>
#include <i2c.h>
#include <pcf8574.h>


/*-----------------------------------------------------------------------------
 * PCF8574 Register Read Routine
 *
 * This device only requires the slave address (device i2c address) to 
 * get the data from the I/O port. No register byte address is present.
 *---------------------------------------------------------------------------*/
uchar pcf8574_read( void )
{
    uchar buf;

    i2c_read(PCF8574_I2C_ADDR, 0, 0, &buf, 1);

    return( buf );
}

/*-----------------------------------------------------------------------------
 * PCF8574 Register Write Routine
 *
 * This device only requires the slave address (device i2c address) to 
 * get the data from the I/O port. No register byte address is present.
 *---------------------------------------------------------------------------*/
void pcf8574_write( uchar val )
{
    i2c_write(PCF8574_I2C_ADDR, 0, 0, &val, 1);

    return;
}
