/*****************************************************************************
 *  Power Supply Utilities Menu
 *
 *  FILE: power_menu.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>

#if defined(CFG_RARITAN_UTIL_POWER)

#include <power_menu.h>
#include <power.h>
#include <util.h>


static void print_power_menu( void )
{
    printf("\nPower Supply Utility:");
    print_exit();
    printf("\n\t 1: Get Status");
    printf("\n\n");

    return;
}

int power_menu( void )
{
    char power_flag = 1;
    int result = 1;
    unsigned long diag_opt;
    int opt_res;

    while (power_flag) {
        print_power_menu();

        opt_res = menu_get_user_input(&diag_opt);
        if( opt_res > 0 ) {
            return 0;
        }
        else if( opt_res < 0 ) {
            continue;
        }

        switch( diag_opt ) {
            case POWER_MENU_EXIT:
                power_flag = 0;
                break;

            case POWER_MENU_STATUS:
                power_get_status();
                break;

            default:
                print_invalid();
                break;
        }
    }

    return result;
}

#endif /* (CFG_RARITAN_UTIL_POWER) */
