/*****************************************************************************
 *  Real-Time Clock Utilities Menu header file
 *
 *  FILE: rtc_menu.h
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _RTC_MENU_H_
#define _RTC_MENU_H_

#include <rtc.h>

typedef enum {
    RTC_MENU_EXIT,
    RTC_MENU_READ_ALL,
    RTC_MENU_READ,
    RTC_MENU_WRITE,
    RTC_MENU_GET,
    RTC_MENU_SET,
    RTC_MENU_RESET,
    RTC_MENU_STOP,
    RTC_MENU_START,
    RTC_MENU_RESET_HALT_UPDATE,
    RTC_MENU_STORE_DATA,
    RTC_MENU_RECALL_DATA,
    RTC_MENU_GET_ALARM,
    RTC_MENU_SET_ALARM,
    RTC_MENU_SET_WATCHDOG,
    RTC_MENU_CLR_WATCHDOG,
    RTC_MENU_TEST_BCD2BIN,
    RTC_MENU_TEST_BIN2BCD,
    NUM_RTC_MENU
} rtc_menu_t;


extern int get_rtc_args( struct rtc_time *ptime, uchar alarm );
extern int rtc_menu( void );

#endif /* _RTC_MENU_ */
